/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.SentryOptions;
import io.sentry.protocol.User;
import io.sentry.spring.SentryUserProvider;
import io.sentry.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class HttpServletRequestSentryUserProvider
implements SentryUserProvider {
    @NotNull
    private final SentryOptions options;

    public HttpServletRequestSentryUserProvider(@NotNull SentryOptions options) {
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"options are required");
    }

    @Override
    @Nullable
    public User provideUser() {
        RequestAttributes requestAttributes;
        if (this.options.isSendDefaultPii() && (requestAttributes = RequestContextHolder.getRequestAttributes()) instanceof ServletRequestAttributes) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
            HttpServletRequest request = servletRequestAttributes.getRequest();
            User user = new User();
            user.setIpAddress(HttpServletRequestSentryUserProvider.toIpAddress(request));
            if (request.getUserPrincipal() != null) {
                user.setUsername(request.getUserPrincipal().getName());
            }
            return user;
        }
        return null;
    }

    @NotNull
    private static String toIpAddress(@NotNull HttpServletRequest request) {
        String ipAddress = request.getHeader("X-FORWARDED-FOR");
        if (ipAddress != null) {
            return ipAddress.contains(",") ? ipAddress.split(",")[0].trim() : ipAddress;
        }
        return request.getRemoteAddr();
    }
}

