/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.webflux;

import io.sentry.Hint;
import io.sentry.IScopes;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.protocol.Mechanism;
import io.sentry.spring.webflux.TransactionNameProvider;
import io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Mono;

@Order(value=-2)
@ApiStatus.Experimental
public final class SentryWebExceptionHandler
implements WebExceptionHandler {
    public static final String MECHANISM_TYPE = "Spring5WebFluxExceptionResolver";
    @NotNull
    private final IScopes scopes;

    public SentryWebExceptionHandler(@NotNull IScopes scopes) {
        this.scopes = (IScopes)Objects.requireNonNull((Object)scopes, (String)"scopes are required");
    }

    @NotNull
    public Mono<Void> handle(@NotNull ServerWebExchange serverWebExchange, @NotNull Throwable ex) {
        if (!(ex instanceof ResponseStatusException)) {
            Mechanism mechanism = new Mechanism();
            mechanism.setType(MECHANISM_TYPE);
            mechanism.setHandled(Boolean.valueOf(false));
            ExceptionMechanismException throwable = new ExceptionMechanismException(mechanism, ex, Thread.currentThread());
            SentryEvent event = new SentryEvent((Throwable)throwable);
            event.setLevel(SentryLevel.FATAL);
            event.setTransaction(TransactionNameProvider.provideTransactionName(serverWebExchange));
            Hint hint = new Hint();
            hint.set("webFluxExceptionHandler:request", (Object)serverWebExchange.getRequest());
            hint.set("webFluxExceptionHandler:response", (Object)serverWebExchange.getResponse());
            hint.set("webFluxExceptionHandler:exchange", (Object)serverWebExchange);
            this.scopes.captureEvent(event, hint);
        }
        return Mono.error((Throwable)ex);
    }
}

