/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.interfaces.Extension;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.workflow.BaseWorkflow;
import io.serverlessworkflow.api.workflow.Events;
import io.serverlessworkflow.api.workflow.Functions;
import io.serverlessworkflow.api.workflow.Retries;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "description", "version", "schemaVersion", "dataInputSchema", "dataOutputSchema", "metadata", "events", "functions", "retries", "states", "extensions"})
public class Workflow
extends BaseWorkflow
implements Serializable {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Workflow unique identifier")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Workflow name")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String name;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Workflow description")
    private String description;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Workflow version")
    @NotNull
    private String version;
    @JsonProperty(value="schemaVersion")
    @JsonPropertyDescription(value="Serverless Workflow schema version")
    private String schemaVersion;
    @JsonProperty(value="dataInputSchema")
    @JsonPropertyDescription(value="URI to JSON Schema that workflow data input adheres to")
    private String dataInputSchema;
    @JsonProperty(value="dataOutputSchema")
    @JsonPropertyDescription(value="URI to JSON Schema that workflow data output adheres to")
    private String dataOutputSchema;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Metadata")
    @Valid
    private Map<String, String> metadata;
    @JsonProperty(value="events")
    @JsonPropertyDescription(value="Workflow event definitions")
    @Valid
    private Events events;
    @JsonProperty(value="functions")
    @JsonPropertyDescription(value="Workflow function definitions")
    @Valid
    private Functions functions;
    @JsonProperty(value="retries")
    @JsonPropertyDescription(value="Workflow retry definitions")
    @Valid
    private Retries retries;
    @JsonProperty(value="states")
    @JsonPropertyDescription(value="State Definitions")
    @Valid
    @NotNull
    private List<State> states = new ArrayList<State>();
    @JsonProperty(value="extensions")
    @JsonPropertyDescription(value="Workflow Extensions")
    @Valid
    private List<Extension> extensions = new ArrayList<Extension>();
    private static final long serialVersionUID = 2993506088471188589L;

    public Workflow() {
    }

    public Workflow(String id, String name, String version, List<State> states) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.states = states;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public Workflow withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Workflow withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Workflow withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    public Workflow withVersion(String version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="schemaVersion")
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="schemaVersion")
    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public Workflow withSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
        return this;
    }

    @JsonProperty(value="dataInputSchema")
    public String getDataInputSchema() {
        return this.dataInputSchema;
    }

    @JsonProperty(value="dataInputSchema")
    public void setDataInputSchema(String dataInputSchema) {
        this.dataInputSchema = dataInputSchema;
    }

    public Workflow withDataInputSchema(String dataInputSchema) {
        this.dataInputSchema = dataInputSchema;
        return this;
    }

    @JsonProperty(value="dataOutputSchema")
    public String getDataOutputSchema() {
        return this.dataOutputSchema;
    }

    @JsonProperty(value="dataOutputSchema")
    public void setDataOutputSchema(String dataOutputSchema) {
        this.dataOutputSchema = dataOutputSchema;
    }

    public Workflow withDataOutputSchema(String dataOutputSchema) {
        this.dataOutputSchema = dataOutputSchema;
        return this;
    }

    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Workflow withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonProperty(value="events")
    public Events getEvents() {
        return this.events;
    }

    @JsonProperty(value="events")
    public void setEvents(Events events) {
        this.events = events;
    }

    public Workflow withEvents(Events events) {
        this.events = events;
        return this;
    }

    @JsonProperty(value="functions")
    public Functions getFunctions() {
        return this.functions;
    }

    @JsonProperty(value="functions")
    public void setFunctions(Functions functions) {
        this.functions = functions;
    }

    public Workflow withFunctions(Functions functions) {
        this.functions = functions;
        return this;
    }

    @JsonProperty(value="retries")
    public Retries getRetries() {
        return this.retries;
    }

    @JsonProperty(value="retries")
    public void setRetries(Retries retries) {
        this.retries = retries;
    }

    public Workflow withRetries(Retries retries) {
        this.retries = retries;
        return this;
    }

    @JsonProperty(value="states")
    public List<State> getStates() {
        return this.states;
    }

    @JsonProperty(value="states")
    public void setStates(List<State> states) {
        this.states = states;
    }

    public Workflow withStates(List<State> states) {
        this.states = states;
        return this;
    }

    @JsonProperty(value="extensions")
    public List<Extension> getExtensions() {
        return this.extensions;
    }

    @JsonProperty(value="extensions")
    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    public Workflow withExtensions(List<Extension> extensions) {
        this.extensions = extensions;
        return this;
    }
}

