/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.serverlessworkflow.api.events.EventDefinition;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import io.serverlessworkflow.api.utils.Utils;
import io.serverlessworkflow.api.workflow.Events;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsDeserializer
extends StdDeserializer<Events> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(EventsDeserializer.class);
    private WorkflowPropertySource context;

    public EventsDeserializer() {
        this(Events.class);
    }

    public EventsDeserializer(Class<?> vc) {
        super(vc);
    }

    public EventsDeserializer(WorkflowPropertySource context) {
        this(Events.class);
        this.context = context;
    }

    public Events deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Events events = new Events();
        ArrayList<EventDefinition> eventDefs = new ArrayList<EventDefinition>();
        if (node.isArray()) {
            for (JsonNode nodeEle : node) {
                eventDefs.add((EventDefinition)mapper.treeToValue((TreeNode)nodeEle, EventDefinition.class));
            }
        } else {
            String eventsFileDef = node.asText();
            String eventsFileSrc = Utils.getResourceFileAsString(eventsFileDef);
            ObjectMapper jsonWriter = new ObjectMapper();
            if (eventsFileSrc != null && eventsFileSrc.trim().length() > 0) {
                JsonNode eventsRefNode;
                if (!eventsFileSrc.trim().startsWith("{")) {
                    ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
                    Object obj = yamlReader.readValue(eventsFileSrc, Object.class);
                    eventsRefNode = jsonWriter.readTree(new JSONObject(jsonWriter.writeValueAsString(obj)).toString());
                } else {
                    eventsRefNode = jsonWriter.readTree(new JSONObject(eventsFileSrc).toString());
                }
                JsonNode refEvents = eventsRefNode.get("events");
                if (refEvents != null) {
                    for (JsonNode nodeEle : refEvents) {
                        eventDefs.add((EventDefinition)mapper.treeToValue((TreeNode)nodeEle, EventDefinition.class));
                    }
                } else {
                    logger.error("Unable to find event definitions in reference file: {}", (Object)eventsFileSrc);
                }
            } else {
                logger.error("Unable to load event defs reference file: {}", (Object)eventsFileSrc);
            }
        }
        events.setEventDefs(eventDefs);
        return events;
    }
}

