/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import io.serverlessworkflow.api.schedule.Schedule;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleDirectInvokeDeserializer
extends StdDeserializer<Schedule.DirectInvoke> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(ScheduleDirectInvokeDeserializer.class);
    private WorkflowPropertySource context;

    public ScheduleDirectInvokeDeserializer() {
        this(Schedule.DirectInvoke.class);
    }

    public ScheduleDirectInvokeDeserializer(WorkflowPropertySource context) {
        this(Schedule.DirectInvoke.class);
        this.context = context;
    }

    public ScheduleDirectInvokeDeserializer(Class<?> vc) {
        super(vc);
    }

    public Schedule.DirectInvoke deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String value = jp.getText();
        if (this.context != null) {
            try {
                String result = this.context.getPropertySource().getProperty(value);
                if (result != null) {
                    return Schedule.DirectInvoke.fromValue(result);
                }
                return Schedule.DirectInvoke.fromValue(jp.getText());
            }
            catch (Exception e) {
                logger.info("Exception trying to evaluate property: {}", (Object)e.getMessage());
                return Schedule.DirectInvoke.fromValue(jp.getText());
            }
        }
        return Schedule.DirectInvoke.fromValue(jp.getText());
    }
}

