/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.functions;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "operation", "metadata"})
public class FunctionDefinition
implements Serializable {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Function unique name")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String name;
    @JsonProperty(value="operation")
    @JsonPropertyDescription(value="Combination of the function/service OpenAPI definition URI and the operationID of the operation that needs to be invoked, separated by a '#'. For example 'https://petstore.swagger.io/v2/swagger.json#getPetById'")
    @Size(min=1)
    private @Size(min=1) String operation;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Metadata")
    @Valid
    private Map<String, String> metadata;
    private static final long serialVersionUID = -4866234450341439383L;

    public FunctionDefinition() {
    }

    public FunctionDefinition(String name) {
        this.name = name;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public FunctionDefinition withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="operation")
    public String getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    public void setOperation(String operation) {
        this.operation = operation;
    }

    public FunctionDefinition withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public FunctionDefinition withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }
}

