/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.mapper;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.serverlessworkflow.api.deserializers.DefaultStateTypeDeserializer;
import io.serverlessworkflow.api.deserializers.EndDefinitionDeserializer;
import io.serverlessworkflow.api.deserializers.EventDefinitionKindDeserializer;
import io.serverlessworkflow.api.deserializers.EventsDeserializer;
import io.serverlessworkflow.api.deserializers.ExtensionDeserializer;
import io.serverlessworkflow.api.deserializers.FunctionsDeserializer;
import io.serverlessworkflow.api.deserializers.OnEventsActionModeDeserializer;
import io.serverlessworkflow.api.deserializers.OperationStateActionModeDeserializer;
import io.serverlessworkflow.api.deserializers.ParallelStateCompletionTypeDeserializer;
import io.serverlessworkflow.api.deserializers.RetriesDeserializer;
import io.serverlessworkflow.api.deserializers.ScheduleDirectInvokeDeserializer;
import io.serverlessworkflow.api.deserializers.StartDefinitionDeserializer;
import io.serverlessworkflow.api.deserializers.StateDeserializer;
import io.serverlessworkflow.api.deserializers.StringValueDeserializer;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.events.EventDefinition;
import io.serverlessworkflow.api.events.OnEvents;
import io.serverlessworkflow.api.interfaces.Extension;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import io.serverlessworkflow.api.schedule.Schedule;
import io.serverlessworkflow.api.serializers.CallbackStateSerializer;
import io.serverlessworkflow.api.serializers.DelayStateSerializer;
import io.serverlessworkflow.api.serializers.EndDefinitionSerializer;
import io.serverlessworkflow.api.serializers.EventStateSerializer;
import io.serverlessworkflow.api.serializers.ExtensionSerializer;
import io.serverlessworkflow.api.serializers.ForEachStateSerializer;
import io.serverlessworkflow.api.serializers.InjectStateSerializer;
import io.serverlessworkflow.api.serializers.OperationStateSerializer;
import io.serverlessworkflow.api.serializers.ParallelStateSerializer;
import io.serverlessworkflow.api.serializers.StartDefinitionSerializer;
import io.serverlessworkflow.api.serializers.SubflowStateSerializer;
import io.serverlessworkflow.api.serializers.SwitchStateSerializer;
import io.serverlessworkflow.api.serializers.WorkflowSerializer;
import io.serverlessworkflow.api.start.Start;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.states.OperationState;
import io.serverlessworkflow.api.states.ParallelState;
import io.serverlessworkflow.api.workflow.Events;
import io.serverlessworkflow.api.workflow.Functions;
import io.serverlessworkflow.api.workflow.Retries;

public class WorkflowModule
extends SimpleModule {
    private static final long serialVersionUID = 510L;
    private WorkflowPropertySource workflowPropertySource;
    private ExtensionSerializer extensionSerializer;
    private ExtensionDeserializer extensionDeserializer;

    public WorkflowModule() {
        this(null);
    }

    public WorkflowModule(WorkflowPropertySource workflowPropertySource) {
        super("workflow-module");
        this.workflowPropertySource = workflowPropertySource;
        this.extensionSerializer = new ExtensionSerializer();
        this.extensionDeserializer = new ExtensionDeserializer(workflowPropertySource);
        this.addDefaultSerializers();
        this.addDefaultDeserializers();
    }

    private void addDefaultSerializers() {
        this.addSerializer((JsonSerializer)new WorkflowSerializer());
        this.addSerializer((JsonSerializer)new EventStateSerializer());
        this.addSerializer((JsonSerializer)new DelayStateSerializer());
        this.addSerializer((JsonSerializer)new OperationStateSerializer());
        this.addSerializer((JsonSerializer)new ParallelStateSerializer());
        this.addSerializer((JsonSerializer)new SwitchStateSerializer());
        this.addSerializer((JsonSerializer)new SubflowStateSerializer());
        this.addSerializer((JsonSerializer)new InjectStateSerializer());
        this.addSerializer((JsonSerializer)new ForEachStateSerializer());
        this.addSerializer((JsonSerializer)new CallbackStateSerializer());
        this.addSerializer((JsonSerializer)new StartDefinitionSerializer());
        this.addSerializer((JsonSerializer)new EndDefinitionSerializer());
        this.addSerializer((JsonSerializer)this.extensionSerializer);
    }

    private void addDefaultDeserializers() {
        this.addDeserializer(State.class, (JsonDeserializer)new StateDeserializer(this.workflowPropertySource));
        this.addDeserializer(String.class, (JsonDeserializer)new StringValueDeserializer(this.workflowPropertySource));
        this.addDeserializer(OnEvents.ActionMode.class, (JsonDeserializer)new OnEventsActionModeDeserializer(this.workflowPropertySource));
        this.addDeserializer(OperationState.ActionMode.class, (JsonDeserializer)new OperationStateActionModeDeserializer(this.workflowPropertySource));
        this.addDeserializer(DefaultState.Type.class, (JsonDeserializer)new DefaultStateTypeDeserializer(this.workflowPropertySource));
        this.addDeserializer(EventDefinition.Kind.class, (JsonDeserializer)new EventDefinitionKindDeserializer(this.workflowPropertySource));
        this.addDeserializer(ParallelState.CompletionType.class, (JsonDeserializer)new ParallelStateCompletionTypeDeserializer(this.workflowPropertySource));
        this.addDeserializer(Schedule.DirectInvoke.class, (JsonDeserializer)new ScheduleDirectInvokeDeserializer(this.workflowPropertySource));
        this.addDeserializer(Retries.class, (JsonDeserializer)new RetriesDeserializer(this.workflowPropertySource));
        this.addDeserializer(Functions.class, (JsonDeserializer)new FunctionsDeserializer(this.workflowPropertySource));
        this.addDeserializer(Events.class, (JsonDeserializer)new EventsDeserializer(this.workflowPropertySource));
        this.addDeserializer(Start.class, (JsonDeserializer)new StartDefinitionDeserializer(this.workflowPropertySource));
        this.addDeserializer(End.class, (JsonDeserializer)new EndDefinitionDeserializer(this.workflowPropertySource));
        this.addDeserializer(Extension.class, (JsonDeserializer)this.extensionDeserializer);
    }

    public ExtensionSerializer getExtensionSerializer() {
        return this.extensionSerializer;
    }

    public ExtensionDeserializer getExtensionDeserializer() {
        return this.extensionDeserializer;
    }
}

