/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.states;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.start.Start;
import io.serverlessworkflow.api.transitions.Transition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "type", "start", "end", "stateDataFilter", "metadata", "transition", "dataInputSchema", "dataOutputSchema", "onErrors", "compensatedBy"})
public class DefaultState
implements Serializable,
State {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="State unique identifier")
    @Size(min=1)
    private @Size(min=1) String id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Unique name of the state")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String name;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="State type")
    @NotNull
    private Type type;
    @JsonProperty(value="start")
    @JsonPropertyDescription(value="State start definition")
    @Valid
    private Start start;
    @JsonProperty(value="end")
    @JsonPropertyDescription(value="State end definition")
    @Valid
    private End end;
    @JsonProperty(value="stateDataFilter")
    @Valid
    private StateDataFilter stateDataFilter;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Metadata")
    @Valid
    private Map<String, String> metadata;
    @JsonProperty(value="transition")
    @Valid
    private Transition transition;
    @JsonProperty(value="dataInputSchema")
    @JsonPropertyDescription(value="URI to JSON Schema that state data input adheres to")
    private String dataInputSchema;
    @JsonProperty(value="dataOutputSchema")
    @JsonPropertyDescription(value="URI to JSON Schema that state data output adheres to")
    private String dataOutputSchema;
    @JsonProperty(value="onErrors")
    @JsonPropertyDescription(value="State error handling definitions")
    @Valid
    private List<Error> onErrors = new ArrayList<Error>();
    @JsonProperty(value="compensatedBy")
    @JsonPropertyDescription(value="Unique Name of a workflow state which is responsible for compensation of this state")
    @Size(min=1)
    private @Size(min=1) String compensatedBy;
    private static final long serialVersionUID = 3404866325973005912L;

    public DefaultState() {
    }

    public DefaultState(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public DefaultState withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public DefaultState withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    public DefaultState withType(Type type) {
        this.type = type;
        return this;
    }

    @Override
    @JsonProperty(value="start")
    public Start getStart() {
        return this.start;
    }

    @JsonProperty(value="start")
    public void setStart(Start start) {
        this.start = start;
    }

    public DefaultState withStart(Start start) {
        this.start = start;
        return this;
    }

    @Override
    @JsonProperty(value="end")
    public End getEnd() {
        return this.end;
    }

    @JsonProperty(value="end")
    public void setEnd(End end) {
        this.end = end;
    }

    public DefaultState withEnd(End end) {
        this.end = end;
        return this;
    }

    @Override
    @JsonProperty(value="stateDataFilter")
    public StateDataFilter getStateDataFilter() {
        return this.stateDataFilter;
    }

    @JsonProperty(value="stateDataFilter")
    public void setStateDataFilter(StateDataFilter stateDataFilter) {
        this.stateDataFilter = stateDataFilter;
    }

    public DefaultState withStateDataFilter(StateDataFilter stateDataFilter) {
        this.stateDataFilter = stateDataFilter;
        return this;
    }

    @Override
    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public DefaultState withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @JsonProperty(value="transition")
    public Transition getTransition() {
        return this.transition;
    }

    @JsonProperty(value="transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public DefaultState withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

    @Override
    @JsonProperty(value="dataInputSchema")
    public String getDataInputSchema() {
        return this.dataInputSchema;
    }

    @JsonProperty(value="dataInputSchema")
    public void setDataInputSchema(String dataInputSchema) {
        this.dataInputSchema = dataInputSchema;
    }

    public DefaultState withDataInputSchema(String dataInputSchema) {
        this.dataInputSchema = dataInputSchema;
        return this;
    }

    @Override
    @JsonProperty(value="dataOutputSchema")
    public String getDataOutputSchema() {
        return this.dataOutputSchema;
    }

    @JsonProperty(value="dataOutputSchema")
    public void setDataOutputSchema(String dataOutputSchema) {
        this.dataOutputSchema = dataOutputSchema;
    }

    public DefaultState withDataOutputSchema(String dataOutputSchema) {
        this.dataOutputSchema = dataOutputSchema;
        return this;
    }

    @Override
    @JsonProperty(value="onErrors")
    public List<Error> getOnErrors() {
        return this.onErrors;
    }

    @JsonProperty(value="onErrors")
    public void setOnErrors(List<Error> onErrors) {
        this.onErrors = onErrors;
    }

    public DefaultState withOnErrors(List<Error> onErrors) {
        this.onErrors = onErrors;
        return this;
    }

    @Override
    @JsonProperty(value="compensatedBy")
    public String getCompensatedBy() {
        return this.compensatedBy;
    }

    @JsonProperty(value="compensatedBy")
    public void setCompensatedBy(String compensatedBy) {
        this.compensatedBy = compensatedBy;
    }

    public DefaultState withCompensatedBy(String compensatedBy) {
        this.compensatedBy = compensatedBy;
        return this;
    }

    public static enum Type {
        EVENT("event"),
        OPERATION("operation"),
        SWITCH("switch"),
        DELAY("delay"),
        PARALLEL("parallel"),
        SUBFLOW("subflow"),
        INJECT("inject"),
        FOREACH("foreach"),
        CALLBACK("callback");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

