/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.states;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.events.OnEvents;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.start.Start;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.transitions.Transition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"exclusive", "onEvents", "timeout"})
public class EventState
extends DefaultState
implements Serializable,
State {
    @JsonProperty(value="exclusive")
    @JsonPropertyDescription(value="If true consuming one of the defined events causes its associated actions to be performed. If false all of the defined events must be consumed in order for actions to be performed")
    private boolean exclusive = true;
    @JsonProperty(value="onEvents")
    @JsonPropertyDescription(value="Define what events trigger one or more actions to be performed")
    @Valid
    private List<OnEvents> onEvents = new ArrayList<OnEvents>();
    @JsonProperty(value="timeout")
    @JsonPropertyDescription(value="Time period to wait for incoming events (ISO 8601 format)")
    private String timeout;
    private static final long serialVersionUID = 1994604164912090415L;

    public EventState() {
    }

    public EventState(String name, DefaultState.Type type) {
        super(name, type);
    }

    @JsonProperty(value="exclusive")
    public boolean isExclusive() {
        return this.exclusive;
    }

    @JsonProperty(value="exclusive")
    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public EventState withExclusive(boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    @JsonProperty(value="onEvents")
    public List<OnEvents> getOnEvents() {
        return this.onEvents;
    }

    @JsonProperty(value="onEvents")
    public void setOnEvents(List<OnEvents> onEvents) {
        this.onEvents = onEvents;
    }

    public EventState withOnEvents(List<OnEvents> onEvents) {
        this.onEvents = onEvents;
        return this;
    }

    @JsonProperty(value="timeout")
    public String getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="timeout")
    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public EventState withTimeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public EventState withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public EventState withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public EventState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public EventState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public EventState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public EventState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public EventState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public EventState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public EventState withDataInputSchema(String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public EventState withDataOutputSchema(String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public EventState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public EventState withCompensatedBy(String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }
}

