/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.states;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.actions.Action;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.start.Start;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.transitions.Transition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"inputCollection", "outputCollection", "iterationParam", "max", "actions", "workflowId", "usedForCompensation"})
public class ForEachState
extends DefaultState
implements Serializable,
State {
    @JsonProperty(value="inputCollection")
    @JsonPropertyDescription(value="JsonPath expression selecting an array element of the states data")
    private String inputCollection;
    @JsonProperty(value="outputCollection")
    @JsonPropertyDescription(value="JsonPath expression specifying an array element of the states data to add the results of each iteration")
    private String outputCollection;
    @JsonProperty(value="iterationParam")
    @JsonPropertyDescription(value="Name of the iteration parameter that can be referenced in actions/workflow. For each parallel iteration, this param should contain an unique element of the inputCollection array")
    private String iterationParam;
    @JsonProperty(value="max")
    @JsonPropertyDescription(value="Specifies how upper bound on how many iterations may run in parallel")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") int max = 0;
    @JsonProperty(value="actions")
    @JsonPropertyDescription(value="Actions to be executed for each of the elements of inputCollection")
    @Valid
    private List<Action> actions = new ArrayList<Action>();
    @JsonProperty(value="workflowId")
    @JsonPropertyDescription(value="Unique Id of a workflow to be executed for each of the elements of inputCollection")
    private String workflowId;
    @JsonProperty(value="usedForCompensation")
    @JsonPropertyDescription(value="If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    private static final long serialVersionUID = -2926799326147401132L;

    public ForEachState() {
    }

    public ForEachState(String name, DefaultState.Type type) {
        super(name, type);
    }

    @JsonProperty(value="inputCollection")
    public String getInputCollection() {
        return this.inputCollection;
    }

    @JsonProperty(value="inputCollection")
    public void setInputCollection(String inputCollection) {
        this.inputCollection = inputCollection;
    }

    public ForEachState withInputCollection(String inputCollection) {
        this.inputCollection = inputCollection;
        return this;
    }

    @JsonProperty(value="outputCollection")
    public String getOutputCollection() {
        return this.outputCollection;
    }

    @JsonProperty(value="outputCollection")
    public void setOutputCollection(String outputCollection) {
        this.outputCollection = outputCollection;
    }

    public ForEachState withOutputCollection(String outputCollection) {
        this.outputCollection = outputCollection;
        return this;
    }

    @JsonProperty(value="iterationParam")
    public String getIterationParam() {
        return this.iterationParam;
    }

    @JsonProperty(value="iterationParam")
    public void setIterationParam(String iterationParam) {
        this.iterationParam = iterationParam;
    }

    public ForEachState withIterationParam(String iterationParam) {
        this.iterationParam = iterationParam;
        return this;
    }

    @JsonProperty(value="max")
    public int getMax() {
        return this.max;
    }

    @JsonProperty(value="max")
    public void setMax(int max) {
        this.max = max;
    }

    public ForEachState withMax(int max) {
        this.max = max;
        return this;
    }

    @JsonProperty(value="actions")
    public List<Action> getActions() {
        return this.actions;
    }

    @JsonProperty(value="actions")
    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public ForEachState withActions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    @JsonProperty(value="workflowId")
    public String getWorkflowId() {
        return this.workflowId;
    }

    @JsonProperty(value="workflowId")
    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public ForEachState withWorkflowId(String workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    @JsonProperty(value="usedForCompensation")
    public boolean isUsedForCompensation() {
        return this.usedForCompensation;
    }

    @JsonProperty(value="usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public ForEachState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @Override
    public ForEachState withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ForEachState withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ForEachState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public ForEachState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public ForEachState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public ForEachState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public ForEachState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public ForEachState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public ForEachState withDataInputSchema(String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public ForEachState withDataOutputSchema(String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public ForEachState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public ForEachState withCompensatedBy(String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }
}

