/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.states;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.start.Start;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.transitions.Transition;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"data", "usedForCompensation"})
public class InjectState
extends DefaultState
implements Serializable,
State {
    @JsonProperty(value="data")
    @JsonPropertyDescription(value="JSON object which can be set as states data input and can be manipulated via filters")
    @Valid
    private JsonNode data;
    @JsonProperty(value="usedForCompensation")
    @JsonPropertyDescription(value="If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    private static final long serialVersionUID = -4059730162120471375L;

    public InjectState() {
    }

    public InjectState(String name, DefaultState.Type type) {
        super(name, type);
    }

    @JsonProperty(value="data")
    public JsonNode getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(JsonNode data) {
        this.data = data;
    }

    public InjectState withData(JsonNode data) {
        this.data = data;
        return this;
    }

    @JsonProperty(value="usedForCompensation")
    public boolean isUsedForCompensation() {
        return this.usedForCompensation;
    }

    @JsonProperty(value="usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public InjectState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @Override
    public InjectState withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public InjectState withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public InjectState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public InjectState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public InjectState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public InjectState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public InjectState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public InjectState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public InjectState withDataInputSchema(String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public InjectState withDataOutputSchema(String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public InjectState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public InjectState withCompensatedBy(String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }
}

