/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.states;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.serverlessworkflow.api.actions.Action;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.start.Start;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.transitions.Transition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"actionMode", "actions", "usedForCompensation"})
public class OperationState
extends DefaultState
implements Serializable,
State {
    @JsonProperty(value="actionMode")
    @JsonPropertyDescription(value="Specifies whether functions are executed in sequence or in parallel.")
    @NotNull
    private ActionMode actionMode;
    @JsonProperty(value="actions")
    @JsonPropertyDescription(value="Actions Definitions")
    @Valid
    @NotNull
    private List<Action> actions = new ArrayList<Action>();
    @JsonProperty(value="usedForCompensation")
    @JsonPropertyDescription(value="If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    private static final long serialVersionUID = -1213630097689460329L;

    public OperationState() {
    }

    public OperationState(ActionMode actionMode, List<Action> actions, String name, DefaultState.Type type) {
        super(name, type);
        this.actionMode = actionMode;
        this.actions = actions;
    }

    @JsonProperty(value="actionMode")
    public ActionMode getActionMode() {
        return this.actionMode;
    }

    @JsonProperty(value="actionMode")
    public void setActionMode(ActionMode actionMode) {
        this.actionMode = actionMode;
    }

    public OperationState withActionMode(ActionMode actionMode) {
        this.actionMode = actionMode;
        return this;
    }

    @JsonProperty(value="actions")
    public List<Action> getActions() {
        return this.actions;
    }

    @JsonProperty(value="actions")
    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public OperationState withActions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    @JsonProperty(value="usedForCompensation")
    public boolean isUsedForCompensation() {
        return this.usedForCompensation;
    }

    @JsonProperty(value="usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public OperationState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @Override
    public OperationState withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public OperationState withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public OperationState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public OperationState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public OperationState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public OperationState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public OperationState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public OperationState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public OperationState withDataInputSchema(String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public OperationState withDataOutputSchema(String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public OperationState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public OperationState withCompensatedBy(String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }

    public static enum ActionMode {
        SEQUENTIAL("sequential"),
        PARALLEL("parallel");

        private final String value;
        private static final Map<String, ActionMode> CONSTANTS;

        private ActionMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ActionMode fromValue(String value) {
            ActionMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ActionMode>();
            for (ActionMode c : ActionMode.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

