/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.states;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.defaultdef.DefaultDefinition;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.start.Start;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.switchconditions.DataCondition;
import io.serverlessworkflow.api.switchconditions.EventCondition;
import io.serverlessworkflow.api.transitions.Transition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"eventConditions", "dataConditions", "eventTimeout", "default", "usedForCompensation"})
public class SwitchState
extends DefaultState
implements Serializable,
State {
    @JsonProperty(value="eventConditions")
    @JsonPropertyDescription(value="Defines conditions evaluated against events")
    @Valid
    private List<EventCondition> eventConditions = new ArrayList<EventCondition>();
    @JsonProperty(value="dataConditions")
    @JsonPropertyDescription(value="Defines conditions evaluated against state data")
    @Valid
    private List<DataCondition> dataConditions = new ArrayList<DataCondition>();
    @JsonProperty(value="eventTimeout")
    @JsonPropertyDescription(value="If eventConditions is used, defines the time period to wait for events (ISO 8601 format)")
    private String eventTimeout;
    @JsonProperty(value="default")
    @JsonPropertyDescription(value="Switch state default definition")
    @Valid
    @NotNull
    private DefaultDefinition _default;
    @JsonProperty(value="usedForCompensation")
    @JsonPropertyDescription(value="If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    private static final long serialVersionUID = -5509761874246090017L;

    public SwitchState() {
    }

    public SwitchState(DefaultDefinition _default, String name, DefaultState.Type type) {
        super(name, type);
        this._default = _default;
    }

    @JsonProperty(value="eventConditions")
    public List<EventCondition> getEventConditions() {
        return this.eventConditions;
    }

    @JsonProperty(value="eventConditions")
    public void setEventConditions(List<EventCondition> eventConditions) {
        this.eventConditions = eventConditions;
    }

    public SwitchState withEventConditions(List<EventCondition> eventConditions) {
        this.eventConditions = eventConditions;
        return this;
    }

    @JsonProperty(value="dataConditions")
    public List<DataCondition> getDataConditions() {
        return this.dataConditions;
    }

    @JsonProperty(value="dataConditions")
    public void setDataConditions(List<DataCondition> dataConditions) {
        this.dataConditions = dataConditions;
    }

    public SwitchState withDataConditions(List<DataCondition> dataConditions) {
        this.dataConditions = dataConditions;
        return this;
    }

    @JsonProperty(value="eventTimeout")
    public String getEventTimeout() {
        return this.eventTimeout;
    }

    @JsonProperty(value="eventTimeout")
    public void setEventTimeout(String eventTimeout) {
        this.eventTimeout = eventTimeout;
    }

    public SwitchState withEventTimeout(String eventTimeout) {
        this.eventTimeout = eventTimeout;
        return this;
    }

    @JsonProperty(value="default")
    public DefaultDefinition getDefault() {
        return this._default;
    }

    @JsonProperty(value="default")
    public void setDefault(DefaultDefinition _default) {
        this._default = _default;
    }

    public SwitchState withDefault(DefaultDefinition _default) {
        this._default = _default;
        return this;
    }

    @JsonProperty(value="usedForCompensation")
    public boolean isUsedForCompensation() {
        return this.usedForCompensation;
    }

    @JsonProperty(value="usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public SwitchState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @Override
    public SwitchState withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public SwitchState withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SwitchState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public SwitchState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public SwitchState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public SwitchState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public SwitchState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public SwitchState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public SwitchState withDataInputSchema(String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public SwitchState withDataOutputSchema(String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public SwitchState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public SwitchState withCompensatedBy(String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }
}

