/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.transitions;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.produce.ProduceEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"expression", "produceEvents", "nextState", "compensate"})
public class Transition
implements Serializable {
    @JsonProperty(value="expression")
    @JsonPropertyDescription(value="Common Expression Language (CEL) expression. Must evaluate to true for the transition to be valid")
    private String expression;
    @JsonProperty(value="produceEvents")
    @JsonPropertyDescription(value="Array of events to be produced")
    @Valid
    private List<ProduceEvent> produceEvents = new ArrayList<ProduceEvent>();
    @JsonProperty(value="nextState")
    @JsonPropertyDescription(value="State to transition to next")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String nextState;
    @JsonProperty(value="compensate")
    @JsonPropertyDescription(value="If set to true, triggers workflow compensation before this transition is taken. Default is false")
    private boolean compensate = false;
    private static final long serialVersionUID = 8242978917607985217L;

    public Transition() {
    }

    public Transition(String nextState) {
        this.nextState = nextState;
    }

    @JsonProperty(value="expression")
    public String getExpression() {
        return this.expression;
    }

    @JsonProperty(value="expression")
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Transition withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    @JsonProperty(value="produceEvents")
    public List<ProduceEvent> getProduceEvents() {
        return this.produceEvents;
    }

    @JsonProperty(value="produceEvents")
    public void setProduceEvents(List<ProduceEvent> produceEvents) {
        this.produceEvents = produceEvents;
    }

    public Transition withProduceEvents(List<ProduceEvent> produceEvents) {
        this.produceEvents = produceEvents;
        return this;
    }

    @JsonProperty(value="nextState")
    public String getNextState() {
        return this.nextState;
    }

    @JsonProperty(value="nextState")
    public void setNextState(String nextState) {
        this.nextState = nextState;
    }

    public Transition withNextState(String nextState) {
        this.nextState = nextState;
        return this;
    }

    @JsonProperty(value="compensate")
    public boolean isCompensate() {
        return this.compensate;
    }

    @JsonProperty(value="compensate")
    public void setCompensate(boolean compensate) {
        this.compensate = compensate;
    }

    public Transition withCompensate(boolean compensate) {
        this.compensate = compensate;
        return this;
    }
}

