/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import io.serverlessworkflow.api.states.CallbackState;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.states.DelayState;
import io.serverlessworkflow.api.states.EventState;
import io.serverlessworkflow.api.states.ForEachState;
import io.serverlessworkflow.api.states.InjectState;
import io.serverlessworkflow.api.states.OperationState;
import io.serverlessworkflow.api.states.ParallelState;
import io.serverlessworkflow.api.states.SubflowState;
import io.serverlessworkflow.api.states.SwitchState;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateDeserializer
extends StdDeserializer<State> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(StateDeserializer.class);
    private WorkflowPropertySource context;

    public StateDeserializer() {
        this(State.class);
    }

    public StateDeserializer(Class<?> vc) {
        super(vc);
    }

    public StateDeserializer(WorkflowPropertySource context) {
        this(State.class);
        this.context = context;
    }

    public State deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String typeValue = node.get("type").asText();
        if (this.context != null) {
            try {
                String result = this.context.getPropertySource().getProperty(typeValue);
                if (result != null) {
                    typeValue = result;
                }
            }
            catch (Exception e) {
                logger.info("Exception trying to evaluate property: {}", (Object)e.getMessage());
            }
        }
        DefaultState.Type type = DefaultState.Type.fromValue(typeValue);
        switch (type) {
            case EVENT: {
                return (State)mapper.treeToValue((TreeNode)node, EventState.class);
            }
            case OPERATION: {
                return (State)mapper.treeToValue((TreeNode)node, OperationState.class);
            }
            case SWITCH: {
                return (State)mapper.treeToValue((TreeNode)node, SwitchState.class);
            }
            case DELAY: {
                return (State)mapper.treeToValue((TreeNode)node, DelayState.class);
            }
            case PARALLEL: {
                return (State)mapper.treeToValue((TreeNode)node, ParallelState.class);
            }
            case SUBFLOW: {
                return (State)mapper.treeToValue((TreeNode)node, SubflowState.class);
            }
            case INJECT: {
                return (State)mapper.treeToValue((TreeNode)node, InjectState.class);
            }
            case FOREACH: {
                return (State)mapper.treeToValue((TreeNode)node, ForEachState.class);
            }
            case CALLBACK: {
                return (State)mapper.treeToValue((TreeNode)node, CallbackState.class);
            }
        }
        return (State)mapper.treeToValue((TreeNode)node, DefaultState.class);
    }
}

