/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import io.serverlessworkflow.api.produce.ProduceEvent;
import io.serverlessworkflow.api.transitions.Transition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitionDeserializer
extends StdDeserializer<Transition> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(TransitionDeserializer.class);
    private WorkflowPropertySource context;

    public TransitionDeserializer() {
        this(Transition.class);
    }

    public TransitionDeserializer(Class<?> vc) {
        super(vc);
    }

    public TransitionDeserializer(WorkflowPropertySource context) {
        this(Transition.class);
        this.context = context;
    }

    public Transition deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Transition transition = new Transition();
        if (!node.isObject()) {
            transition.setProduceEvents(new ArrayList<ProduceEvent>());
            transition.setCompensate(false);
            transition.setNextState(node.asText());
            return transition;
        }
        if (node.get("produceEvents") != null) {
            transition.setProduceEvents(Arrays.asList((ProduceEvent[])mapper.treeToValue((TreeNode)node.get("produceEvents"), ProduceEvent[].class)));
        }
        if (node.get("nextState") != null) {
            transition.setNextState(node.get("nextState").asText());
        }
        if (node.get("compensate") != null) {
            transition.setCompensate(node.get("compensate").asBoolean());
        }
        return transition;
    }
}

