/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.retry;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "delay", "multiplier", "maxAttempts", "jitter"})
public class RetryDefinition
implements Serializable {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Unique retry strategy name")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String name;
    @JsonProperty(value="delay")
    @JsonPropertyDescription(value="Time delay between retry attempts (ISO 8601 duration format)")
    private String delay;
    @JsonProperty(value="multiplier")
    @JsonPropertyDescription(value="Multiplier value by which interval increases during each attempt (ISO 8601 time format)")
    private String multiplier;
    @JsonProperty(value="maxAttempts")
    @JsonPropertyDescription(value="Maximum number of retry attempts. Value of 0 means no retries are performed")
    @NotNull
    private String maxAttempts = "0";
    @JsonProperty(value="jitter")
    @JsonPropertyDescription(value="Absolute maximum amount of random time added or subtracted from the delay between each retry (ISO 8601 duration format)")
    @DecimalMin(value="0")
    @DecimalMax(value="1")
    private @DecimalMin(value="0") @DecimalMax(value="1") String jitter;
    private static final long serialVersionUID = -2085728379200915216L;

    public RetryDefinition() {
    }

    public RetryDefinition(String name, String maxAttempts) {
        this.name = name;
        this.maxAttempts = maxAttempts;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public RetryDefinition withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="delay")
    public String getDelay() {
        return this.delay;
    }

    @JsonProperty(value="delay")
    public void setDelay(String delay) {
        this.delay = delay;
    }

    public RetryDefinition withDelay(String delay) {
        this.delay = delay;
        return this;
    }

    @JsonProperty(value="multiplier")
    public String getMultiplier() {
        return this.multiplier;
    }

    @JsonProperty(value="multiplier")
    public void setMultiplier(String multiplier) {
        this.multiplier = multiplier;
    }

    public RetryDefinition withMultiplier(String multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    @JsonProperty(value="maxAttempts")
    public String getMaxAttempts() {
        return this.maxAttempts;
    }

    @JsonProperty(value="maxAttempts")
    public void setMaxAttempts(String maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public RetryDefinition withMaxAttempts(String maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

    @JsonProperty(value="jitter")
    public String getJitter() {
        return this.jitter;
    }

    @JsonProperty(value="jitter")
    public void setJitter(String jitter) {
        this.jitter = jitter;
    }

    public RetryDefinition withJitter(String jitter) {
        this.jitter = jitter;
        return this;
    }
}

