/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.states;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.transitions.Transition;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"timeDelay", "usedForCompensation"})
public class DelayState
extends DefaultState
implements Serializable,
State {
    @JsonProperty(value="timeDelay")
    @JsonPropertyDescription(value="Amount of time (ISO 8601 format) to delay")
    @NotNull
    private String timeDelay;
    @JsonProperty(value="usedForCompensation")
    @JsonPropertyDescription(value="If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    private static final long serialVersionUID = 4952611582741988773L;

    public DelayState() {
    }

    public DelayState(String timeDelay, String name, DefaultState.Type type) {
        super(name, type);
        this.timeDelay = timeDelay;
    }

    @JsonProperty(value="timeDelay")
    public String getTimeDelay() {
        return this.timeDelay;
    }

    @JsonProperty(value="timeDelay")
    public void setTimeDelay(String timeDelay) {
        this.timeDelay = timeDelay;
    }

    public DelayState withTimeDelay(String timeDelay) {
        this.timeDelay = timeDelay;
        return this;
    }

    @JsonProperty(value="usedForCompensation")
    public boolean isUsedForCompensation() {
        return this.usedForCompensation;
    }

    @JsonProperty(value="usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public DelayState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @Override
    public DelayState withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public DelayState withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public DelayState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public DelayState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public DelayState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public DelayState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public DelayState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public DelayState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public DelayState withCompensatedBy(String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }
}

