/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.end.ContinueAs;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import io.serverlessworkflow.api.produce.ProduceEvent;
import io.serverlessworkflow.api.start.Start;
import java.io.IOException;
import java.util.ArrayList;

public class EndDefinitionDeserializer
extends StdDeserializer<End> {
    private static final long serialVersionUID = 510L;
    private WorkflowPropertySource context;

    public EndDefinitionDeserializer() {
        this(End.class);
    }

    public EndDefinitionDeserializer(Class<?> vc) {
        super(vc);
    }

    public EndDefinitionDeserializer(WorkflowPropertySource context) {
        this(Start.class);
        this.context = context;
    }

    public End deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        End end = new End();
        if (node.isBoolean()) {
            end.setProduceEvents(null);
            end.setCompensate(false);
            end.setTerminate(false);
            end.setContinueAs(null);
            return node.asBoolean() ? end : null;
        }
        if (node.get("produceEvents") != null) {
            ArrayList<ProduceEvent> produceEvents = new ArrayList<ProduceEvent>();
            for (JsonNode nodeEle : node.get("produceEvents")) {
                produceEvents.add((ProduceEvent)mapper.treeToValue((TreeNode)nodeEle, ProduceEvent.class));
            }
            end.setProduceEvents(produceEvents);
        }
        if (node.get("terminate") != null) {
            end.setTerminate(node.get("terminate").asBoolean());
        } else {
            end.setTerminate(false);
        }
        if (node.get("compensate") != null) {
            end.setCompensate(node.get("compensate").asBoolean());
        } else {
            end.setCompensate(false);
        }
        if (node.get("continueAs") != null) {
            end.setContinueAs((ContinueAs)mapper.treeToValue((TreeNode)node.get("continueAs"), ContinueAs.class));
        }
        return end;
    }
}

