/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import io.serverlessworkflow.api.retry.RetryDefinition;
import io.serverlessworkflow.api.utils.Utils;
import io.serverlessworkflow.api.workflow.Retries;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetriesDeserializer
extends StdDeserializer<Retries> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(RetriesDeserializer.class);
    private WorkflowPropertySource context;

    public RetriesDeserializer() {
        this(Retries.class);
    }

    public RetriesDeserializer(Class<?> vc) {
        super(vc);
    }

    public RetriesDeserializer(WorkflowPropertySource context) {
        this(Retries.class);
        this.context = context;
    }

    public Retries deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Retries retries = new Retries();
        ArrayList<RetryDefinition> retryDefinitions = new ArrayList<RetryDefinition>();
        if (node.isArray()) {
            for (JsonNode nodeEle : node) {
                retryDefinitions.add((RetryDefinition)mapper.treeToValue((TreeNode)nodeEle, RetryDefinition.class));
            }
        } else {
            String retriesFileDef = node.asText();
            String retriesFileSrc = Utils.getResourceFileAsString(retriesFileDef);
            ObjectMapper jsonWriter = new ObjectMapper();
            if (retriesFileSrc != null && retriesFileSrc.trim().length() > 0) {
                JsonNode retriesRefNode;
                if (!retriesFileSrc.trim().startsWith("{")) {
                    ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
                    Object obj = yamlReader.readValue(retriesFileSrc, Object.class);
                    retriesRefNode = jsonWriter.readTree(new JSONObject(jsonWriter.writeValueAsString(obj)).toString());
                } else {
                    retriesRefNode = jsonWriter.readTree(new JSONObject(retriesFileSrc).toString());
                }
                JsonNode refRetries = retriesRefNode.get("retries");
                if (refRetries != null) {
                    for (JsonNode nodeEle : refRetries) {
                        retryDefinitions.add((RetryDefinition)mapper.treeToValue((TreeNode)nodeEle, RetryDefinition.class));
                    }
                } else {
                    logger.error("Unable to find retries definitions in reference file: {}", (Object)retriesFileSrc);
                }
            } else {
                logger.error("Unable to load retries defs reference file: {}", (Object)retriesFileSrc);
            }
        }
        retries.setRetryDefs(retryDefinitions);
        return retries;
    }
}

