/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.filters;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"fromStateData", "results", "toStateData", "useResults"})
public class ActionDataFilter
implements Serializable {
    @JsonProperty(value="fromStateData")
    @JsonPropertyDescription(value="Workflow expression that selects state data that the state action can use")
    private String fromStateData;
    @JsonProperty(value="results")
    @JsonPropertyDescription(value="Workflow expression that filters the actions data results")
    private String results;
    @JsonProperty(value="toStateData")
    @JsonPropertyDescription(value="Workflow expression that selects a state data element to which the action results should be added/merged into. If not specified, denote, the top-level state data element")
    private String toStateData;
    @JsonProperty(value="useResults")
    @JsonPropertyDescription(value="If set to false, action data results are not added/merged to state data. In this case 'results' and 'toStateData' should be ignored. Default is true.")
    private boolean useResults = true;
    private static final long serialVersionUID = -8576533856536101663L;

    @JsonProperty(value="fromStateData")
    public String getFromStateData() {
        return this.fromStateData;
    }

    @JsonProperty(value="fromStateData")
    public void setFromStateData(String fromStateData) {
        this.fromStateData = fromStateData;
    }

    public ActionDataFilter withFromStateData(String fromStateData) {
        this.fromStateData = fromStateData;
        return this;
    }

    @JsonProperty(value="results")
    public String getResults() {
        return this.results;
    }

    @JsonProperty(value="results")
    public void setResults(String results) {
        this.results = results;
    }

    public ActionDataFilter withResults(String results) {
        this.results = results;
        return this;
    }

    @JsonProperty(value="toStateData")
    public String getToStateData() {
        return this.toStateData;
    }

    @JsonProperty(value="toStateData")
    public void setToStateData(String toStateData) {
        this.toStateData = toStateData;
    }

    public ActionDataFilter withToStateData(String toStateData) {
        this.toStateData = toStateData;
        return this;
    }

    @JsonProperty(value="useResults")
    public boolean isUseResults() {
        return this.useResults;
    }

    @JsonProperty(value="useResults")
    public void setUseResults(boolean useResults) {
        this.useResults = useResults;
    }

    public ActionDataFilter withUseResults(boolean useResults) {
        this.useResults = useResults;
        return this;
    }
}

