/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.datainputschema;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"schema", "failOnValidationErrors"})
public class DataInputSchema
implements Serializable {
    @JsonProperty(value="schema")
    @JsonPropertyDescription(value="URI of the JSON Schema used to validate the workflow data input")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String schema;
    @JsonProperty(value="failOnValidationErrors")
    @JsonPropertyDescription(value="Determines if workfow execution should continue if there are validation errors")
    @NotNull
    private boolean failOnValidationErrors = true;
    private static final long serialVersionUID = -5239024246688233784L;

    public DataInputSchema() {
    }

    public DataInputSchema(String schema, boolean failOnValidationErrors) {
        this.schema = schema;
        this.failOnValidationErrors = failOnValidationErrors;
    }

    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public DataInputSchema withSchema(String schema) {
        this.schema = schema;
        return this;
    }

    @JsonProperty(value="failOnValidationErrors")
    public boolean isFailOnValidationErrors() {
        return this.failOnValidationErrors;
    }

    @JsonProperty(value="failOnValidationErrors")
    public void setFailOnValidationErrors(boolean failOnValidationErrors) {
        this.failOnValidationErrors = failOnValidationErrors;
    }

    public DataInputSchema withFailOnValidationErrors(boolean failOnValidationErrors) {
        this.failOnValidationErrors = failOnValidationErrors;
        return this;
    }
}

