/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.states;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.defaultdef.DefaultConditionDefinition;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.switchconditions.DataCondition;
import io.serverlessworkflow.api.switchconditions.EventCondition;
import io.serverlessworkflow.api.timeouts.TimeoutsDefinition;
import io.serverlessworkflow.api.transitions.Transition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"eventConditions", "dataConditions", "defaultCondition", "usedForCompensation"})
public class SwitchState
extends DefaultState
implements Serializable,
State {
    @JsonProperty(value="eventConditions")
    @JsonPropertyDescription(value="Defines conditions evaluated against events")
    @Valid
    private List<EventCondition> eventConditions = new ArrayList<EventCondition>();
    @JsonProperty(value="dataConditions")
    @JsonPropertyDescription(value="Defines conditions evaluated against state data")
    @Valid
    private List<DataCondition> dataConditions = new ArrayList<DataCondition>();
    @JsonProperty(value="defaultCondition")
    @JsonPropertyDescription(value="Switch state default condition definition")
    @Valid
    private DefaultConditionDefinition defaultCondition;
    @JsonProperty(value="usedForCompensation")
    @JsonPropertyDescription(value="If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    private static final long serialVersionUID = 6383799176661595489L;

    public SwitchState() {
    }

    public SwitchState(String name, DefaultState.Type type) {
        super(name, type);
    }

    @JsonProperty(value="eventConditions")
    public List<EventCondition> getEventConditions() {
        return this.eventConditions;
    }

    @JsonProperty(value="eventConditions")
    public void setEventConditions(List<EventCondition> eventConditions) {
        this.eventConditions = eventConditions;
    }

    public SwitchState withEventConditions(List<EventCondition> eventConditions) {
        this.eventConditions = eventConditions;
        return this;
    }

    @JsonProperty(value="dataConditions")
    public List<DataCondition> getDataConditions() {
        return this.dataConditions;
    }

    @JsonProperty(value="dataConditions")
    public void setDataConditions(List<DataCondition> dataConditions) {
        this.dataConditions = dataConditions;
    }

    public SwitchState withDataConditions(List<DataCondition> dataConditions) {
        this.dataConditions = dataConditions;
        return this;
    }

    @JsonProperty(value="defaultCondition")
    public DefaultConditionDefinition getDefaultCondition() {
        return this.defaultCondition;
    }

    @JsonProperty(value="defaultCondition")
    public void setDefaultCondition(DefaultConditionDefinition defaultCondition) {
        this.defaultCondition = defaultCondition;
    }

    public SwitchState withDefaultCondition(DefaultConditionDefinition defaultCondition) {
        this.defaultCondition = defaultCondition;
        return this;
    }

    @JsonProperty(value="usedForCompensation")
    public boolean isUsedForCompensation() {
        return this.usedForCompensation;
    }

    @JsonProperty(value="usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public SwitchState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @Override
    public SwitchState withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public SwitchState withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SwitchState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public SwitchState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public SwitchState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public SwitchState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public SwitchState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public SwitchState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public SwitchState withCompensatedBy(String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }

    @Override
    public SwitchState withTimeouts(TimeoutsDefinition timeouts) {
        super.withTimeouts(timeouts);
        return this;
    }
}

