/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.cron.Cron;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import io.serverlessworkflow.api.schedule.Schedule;
import java.io.IOException;

public class ScheduleDeserializer
extends StdDeserializer<Schedule> {
    private static final long serialVersionUID = 510L;
    private WorkflowPropertySource context;

    public ScheduleDeserializer() {
        this(Schedule.class);
    }

    public ScheduleDeserializer(Class<?> vc) {
        super(vc);
    }

    public ScheduleDeserializer(WorkflowPropertySource context) {
        this(Schedule.class);
        this.context = context;
    }

    public Schedule deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Schedule schedule = new Schedule();
        if (!node.isObject()) {
            schedule.setInterval(node.asText());
            return schedule;
        }
        if (node.get("interval") != null) {
            schedule.setInterval(node.get("interval").asText());
        }
        if (node.get("cron") != null) {
            schedule.setCron((Cron)mapper.treeToValue((TreeNode)node.get("cron"), Cron.class));
        }
        if (node.get("timezone") != null) {
            schedule.setTimezone(node.get("timezone").asText());
        }
        return schedule;
    }
}

