/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"triggerEventRef", "resultEventRef", "resultEventTimeout", "data", "contextAttributes", "invoke"})
public class EventRef
implements Serializable {
    @JsonProperty(value="triggerEventRef")
    @JsonPropertyDescription(value="Reference to the unique name of a 'produced' event definition")
    @NotNull
    private String triggerEventRef;
    @JsonProperty(value="resultEventRef")
    @JsonPropertyDescription(value="Reference to the unique name of a 'consumed' event definition")
    @NotNull
    private String resultEventRef;
    @JsonProperty(value="resultEventTimeout")
    @JsonPropertyDescription(value="Maximum amount of time (ISO 8601 format) to wait for the result event. If not defined it should default to the actionExecutionTimeout")
    private String resultEventTimeout;
    @JsonProperty(value="data")
    @JsonPropertyDescription(value="Expression which selects parts of the states data output to become the data of the produced event.")
    private String data;
    @JsonProperty(value="contextAttributes")
    @JsonPropertyDescription(value="Add additional extension context attributes to the produced event")
    @Valid
    private Map<String, String> contextAttributes;
    @JsonProperty(value="invoke")
    @JsonPropertyDescription(value="Specifies if the function should be invoked sync or async. Default is sync.")
    private Invoke invoke = Invoke.fromValue("sync");
    private static final long serialVersionUID = 6021703727803798401L;

    public EventRef() {
    }

    public EventRef(String triggerEventRef, String resultEventRef) {
        this.triggerEventRef = triggerEventRef;
        this.resultEventRef = resultEventRef;
    }

    @JsonProperty(value="triggerEventRef")
    public String getTriggerEventRef() {
        return this.triggerEventRef;
    }

    @JsonProperty(value="triggerEventRef")
    public void setTriggerEventRef(String triggerEventRef) {
        this.triggerEventRef = triggerEventRef;
    }

    public EventRef withTriggerEventRef(String triggerEventRef) {
        this.triggerEventRef = triggerEventRef;
        return this;
    }

    @JsonProperty(value="resultEventRef")
    public String getResultEventRef() {
        return this.resultEventRef;
    }

    @JsonProperty(value="resultEventRef")
    public void setResultEventRef(String resultEventRef) {
        this.resultEventRef = resultEventRef;
    }

    public EventRef withResultEventRef(String resultEventRef) {
        this.resultEventRef = resultEventRef;
        return this;
    }

    @JsonProperty(value="resultEventTimeout")
    public String getResultEventTimeout() {
        return this.resultEventTimeout;
    }

    @JsonProperty(value="resultEventTimeout")
    public void setResultEventTimeout(String resultEventTimeout) {
        this.resultEventTimeout = resultEventTimeout;
    }

    public EventRef withResultEventTimeout(String resultEventTimeout) {
        this.resultEventTimeout = resultEventTimeout;
        return this;
    }

    @JsonProperty(value="data")
    public String getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(String data) {
        this.data = data;
    }

    public EventRef withData(String data) {
        this.data = data;
        return this;
    }

    @JsonProperty(value="contextAttributes")
    public Map<String, String> getContextAttributes() {
        return this.contextAttributes;
    }

    @JsonProperty(value="contextAttributes")
    public void setContextAttributes(Map<String, String> contextAttributes) {
        this.contextAttributes = contextAttributes;
    }

    public EventRef withContextAttributes(Map<String, String> contextAttributes) {
        this.contextAttributes = contextAttributes;
        return this;
    }

    @JsonProperty(value="invoke")
    public Invoke getInvoke() {
        return this.invoke;
    }

    @JsonProperty(value="invoke")
    public void setInvoke(Invoke invoke) {
        this.invoke = invoke;
    }

    public EventRef withInvoke(Invoke invoke) {
        this.invoke = invoke;
        return this;
    }

    public static enum Invoke {
        SYNC("sync"),
        ASYNC("async");

        private final String value;
        private static final Map<String, Invoke> CONSTANTS;

        private Invoke(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Invoke fromValue(String value) {
            Invoke constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Invoke>();
            for (Invoke c : Invoke.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

