/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.datainputschema.DataInputSchema;
import io.serverlessworkflow.api.interfaces.Extension;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.start.Start;
import io.serverlessworkflow.api.timeouts.TimeoutsDefinition;
import io.serverlessworkflow.api.workflow.Auth;
import io.serverlessworkflow.api.workflow.BaseWorkflow;
import io.serverlessworkflow.api.workflow.Constants;
import io.serverlessworkflow.api.workflow.Errors;
import io.serverlessworkflow.api.workflow.Events;
import io.serverlessworkflow.api.workflow.Functions;
import io.serverlessworkflow.api.workflow.Retries;
import io.serverlessworkflow.api.workflow.Secrets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "key", "name", "description", "version", "annotations", "dataInputSchema", "start", "specVersion", "expressionLang", "keepActive", "autoRetries", "metadata", "events", "functions", "errors", "retries", "secrets", "constants", "timeouts", "auth", "states", "extensions"})
public class Workflow
extends BaseWorkflow
implements Serializable {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Workflow unique identifier")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String id;
    @JsonProperty(value="key")
    @JsonPropertyDescription(value="Workflow Domain-specific identifier")
    private String key;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Workflow name")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String name;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Workflow description")
    private String description;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Workflow version")
    @NotNull
    private String version;
    @JsonProperty(value="annotations")
    @JsonPropertyDescription(value="List of helpful terms describing the workflows intended purpose, subject areas, or other important qualities")
    @Size(min=1)
    @Valid
    private @Size(min=1) @Valid List<String> annotations = new ArrayList<String>();
    @JsonProperty(value="dataInputSchema")
    @JsonPropertyDescription(value="Workflow data input schema")
    @Valid
    private DataInputSchema dataInputSchema;
    @JsonProperty(value="start")
    @JsonPropertyDescription(value="State start definition")
    @Valid
    private Start start;
    @JsonProperty(value="specVersion")
    @JsonPropertyDescription(value="Serverless Workflow schema version")
    private String specVersion;
    @JsonProperty(value="expressionLang")
    @JsonPropertyDescription(value="Identifies the expression language used for workflow expressions. Default is 'jq'")
    @Size(min=1)
    private @Size(min=1) String expressionLang = "jq";
    @JsonProperty(value="keepActive")
    @JsonPropertyDescription(value="If 'true', workflow instances is not terminated when there are no active execution paths. Instance can be terminated via 'terminate end definition' or reaching defined 'execTimeout'")
    private boolean keepActive = false;
    @JsonProperty(value="autoRetries")
    @JsonPropertyDescription(value="If set to true, actions should automatically be retried on unchecked errors. Default is false")
    private boolean autoRetries = false;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Metadata")
    @Valid
    private Map<String, String> metadata;
    @JsonProperty(value="events")
    @JsonPropertyDescription(value="Workflow event definitions")
    @Valid
    private Events events;
    @JsonProperty(value="functions")
    @JsonPropertyDescription(value="Workflow function definitions")
    @Valid
    private Functions functions;
    @JsonProperty(value="errors")
    @JsonPropertyDescription(value="Workflow error definitions")
    @Valid
    private Errors errors;
    @JsonProperty(value="retries")
    @JsonPropertyDescription(value="Workflow retry definitions")
    @Valid
    private Retries retries;
    @JsonProperty(value="secrets")
    @JsonPropertyDescription(value="Workflow secrets definitions")
    @Valid
    private Secrets secrets;
    @JsonProperty(value="constants")
    @JsonPropertyDescription(value="Workflow constants definitions")
    @Valid
    private Constants constants;
    @JsonProperty(value="timeouts")
    @JsonPropertyDescription(value="Timeouts Definition")
    @Valid
    private TimeoutsDefinition timeouts;
    @JsonProperty(value="auth")
    @JsonPropertyDescription(value="Workflow Auth definitions")
    @Valid
    private Auth auth;
    @JsonProperty(value="states")
    @JsonPropertyDescription(value="State Definitions")
    @Valid
    @NotNull
    private List<State> states = new ArrayList<State>();
    @JsonProperty(value="extensions")
    @JsonPropertyDescription(value="Workflow Extensions")
    @Valid
    private List<Extension> extensions = new ArrayList<Extension>();
    private static final long serialVersionUID = -6154536734206835831L;

    public Workflow() {
    }

    public Workflow(String id, String name, String version, List<State> states) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.states = states;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public Workflow withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public Workflow withKey(String key) {
        this.key = key;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Workflow withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Workflow withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    public Workflow withVersion(String version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="annotations")
    public List<String> getAnnotations() {
        return this.annotations;
    }

    @JsonProperty(value="annotations")
    public void setAnnotations(List<String> annotations) {
        this.annotations = annotations;
    }

    public Workflow withAnnotations(List<String> annotations) {
        this.annotations = annotations;
        return this;
    }

    @JsonProperty(value="dataInputSchema")
    public DataInputSchema getDataInputSchema() {
        return this.dataInputSchema;
    }

    @JsonProperty(value="dataInputSchema")
    public void setDataInputSchema(DataInputSchema dataInputSchema) {
        this.dataInputSchema = dataInputSchema;
    }

    public Workflow withDataInputSchema(DataInputSchema dataInputSchema) {
        this.dataInputSchema = dataInputSchema;
        return this;
    }

    @JsonProperty(value="start")
    public Start getStart() {
        return this.start;
    }

    @JsonProperty(value="start")
    public void setStart(Start start) {
        this.start = start;
    }

    public Workflow withStart(Start start) {
        this.start = start;
        return this;
    }

    @JsonProperty(value="specVersion")
    public String getSpecVersion() {
        return this.specVersion;
    }

    @JsonProperty(value="specVersion")
    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    public Workflow withSpecVersion(String specVersion) {
        this.specVersion = specVersion;
        return this;
    }

    @JsonProperty(value="expressionLang")
    public String getExpressionLang() {
        return this.expressionLang;
    }

    @JsonProperty(value="expressionLang")
    public void setExpressionLang(String expressionLang) {
        this.expressionLang = expressionLang;
    }

    public Workflow withExpressionLang(String expressionLang) {
        this.expressionLang = expressionLang;
        return this;
    }

    @JsonProperty(value="keepActive")
    public boolean isKeepActive() {
        return this.keepActive;
    }

    @JsonProperty(value="keepActive")
    public void setKeepActive(boolean keepActive) {
        this.keepActive = keepActive;
    }

    public Workflow withKeepActive(boolean keepActive) {
        this.keepActive = keepActive;
        return this;
    }

    @JsonProperty(value="autoRetries")
    public boolean isAutoRetries() {
        return this.autoRetries;
    }

    @JsonProperty(value="autoRetries")
    public void setAutoRetries(boolean autoRetries) {
        this.autoRetries = autoRetries;
    }

    public Workflow withAutoRetries(boolean autoRetries) {
        this.autoRetries = autoRetries;
        return this;
    }

    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Workflow withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonProperty(value="events")
    public Events getEvents() {
        return this.events;
    }

    @JsonProperty(value="events")
    public void setEvents(Events events) {
        this.events = events;
    }

    public Workflow withEvents(Events events) {
        this.events = events;
        return this;
    }

    @JsonProperty(value="functions")
    public Functions getFunctions() {
        return this.functions;
    }

    @JsonProperty(value="functions")
    public void setFunctions(Functions functions) {
        this.functions = functions;
    }

    public Workflow withFunctions(Functions functions) {
        this.functions = functions;
        return this;
    }

    @JsonProperty(value="errors")
    public Errors getErrors() {
        return this.errors;
    }

    @JsonProperty(value="errors")
    public void setErrors(Errors errors) {
        this.errors = errors;
    }

    public Workflow withErrors(Errors errors) {
        this.errors = errors;
        return this;
    }

    @JsonProperty(value="retries")
    public Retries getRetries() {
        return this.retries;
    }

    @JsonProperty(value="retries")
    public void setRetries(Retries retries) {
        this.retries = retries;
    }

    public Workflow withRetries(Retries retries) {
        this.retries = retries;
        return this;
    }

    @JsonProperty(value="secrets")
    public Secrets getSecrets() {
        return this.secrets;
    }

    @JsonProperty(value="secrets")
    public void setSecrets(Secrets secrets) {
        this.secrets = secrets;
    }

    public Workflow withSecrets(Secrets secrets) {
        this.secrets = secrets;
        return this;
    }

    @JsonProperty(value="constants")
    public Constants getConstants() {
        return this.constants;
    }

    @JsonProperty(value="constants")
    public void setConstants(Constants constants) {
        this.constants = constants;
    }

    public Workflow withConstants(Constants constants) {
        this.constants = constants;
        return this;
    }

    @JsonProperty(value="timeouts")
    public TimeoutsDefinition getTimeouts() {
        return this.timeouts;
    }

    @JsonProperty(value="timeouts")
    public void setTimeouts(TimeoutsDefinition timeouts) {
        this.timeouts = timeouts;
    }

    public Workflow withTimeouts(TimeoutsDefinition timeouts) {
        this.timeouts = timeouts;
        return this;
    }

    @JsonProperty(value="auth")
    public Auth getAuth() {
        return this.auth;
    }

    @JsonProperty(value="auth")
    public void setAuth(Auth auth) {
        this.auth = auth;
    }

    public Workflow withAuth(Auth auth) {
        this.auth = auth;
        return this;
    }

    @JsonProperty(value="states")
    public List<State> getStates() {
        return this.states;
    }

    @JsonProperty(value="states")
    public void setStates(List<State> states) {
        this.states = states;
    }

    public Workflow withStates(List<State> states) {
        this.states = states;
        return this;
    }

    @JsonProperty(value="extensions")
    public List<Extension> getExtensions() {
        return this.extensions;
    }

    @JsonProperty(value="extensions")
    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    public Workflow withExtensions(List<Extension> extensions) {
        this.extensions = extensions;
        return this;
    }
}

