/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.auth.AuthDefinition;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import io.serverlessworkflow.api.utils.Utils;
import io.serverlessworkflow.api.workflow.Auth;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthDeserializer
extends StdDeserializer<Auth> {
    private static final long serialVersionUID = 520L;
    private static Logger logger = LoggerFactory.getLogger(AuthDeserializer.class);
    private WorkflowPropertySource context;

    public AuthDeserializer() {
        this(Auth.class);
    }

    public AuthDeserializer(Class<?> vc) {
        super(vc);
    }

    public AuthDeserializer(WorkflowPropertySource context) {
        this(Auth.class);
        this.context = context;
    }

    public Auth deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Auth auth = new Auth();
        ArrayList<AuthDefinition> authDefinitions = new ArrayList<AuthDefinition>();
        if (node.isArray()) {
            for (JsonNode nodeEle : node) {
                authDefinitions.add((AuthDefinition)mapper.treeToValue((TreeNode)nodeEle, AuthDefinition.class));
            }
        } else {
            String authFileDef = node.asText();
            String authFileSrc = Utils.getResourceFileAsString(authFileDef);
            if (authFileSrc != null && authFileSrc.trim().length() > 0) {
                JsonNode authRefNode = Utils.getNode(authFileSrc);
                JsonNode refAuth = authRefNode.get("auth");
                if (refAuth != null) {
                    for (JsonNode nodeEle : refAuth) {
                        authDefinitions.add((AuthDefinition)mapper.treeToValue((TreeNode)nodeEle, AuthDefinition.class));
                    }
                } else {
                    logger.error("Unable to find auth definitions in reference file: {}", (Object)authFileSrc);
                }
            } else {
                logger.error("Unable to load auth defs reference file: {}", (Object)authFileSrc);
            }
        }
        auth.setAuthDefs(authDefinitions);
        return auth;
    }
}

