/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.functions.SubFlowRef;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import java.io.IOException;

public class SubFlowRefDeserializer
extends StdDeserializer<SubFlowRef> {
    private static final long serialVersionUID = 510L;
    private WorkflowPropertySource context;

    public SubFlowRefDeserializer() {
        this(SubFlowRef.class);
    }

    public SubFlowRefDeserializer(Class<?> vc) {
        super(vc);
    }

    public SubFlowRefDeserializer(WorkflowPropertySource context) {
        this(SubFlowRef.class);
        this.context = context;
    }

    public SubFlowRef deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        SubFlowRef subflowRef = new SubFlowRef();
        if (!node.isObject()) {
            subflowRef.setWorkflowId(node.asText());
            return subflowRef;
        }
        if (node.get("workflowId") != null) {
            subflowRef.setWorkflowId(node.get("workflowId").asText());
        }
        if (node.get("version") != null) {
            subflowRef.setVersion(node.get("version").asText());
        }
        if (node.get("onParentComplete") != null) {
            subflowRef.setOnParentComplete(SubFlowRef.OnParentComplete.fromValue(node.get("onParentComplete").asText()));
        }
        if (node.get("invoke") != null) {
            subflowRef.setInvoke(SubFlowRef.Invoke.fromValue(node.get("invoke").asText()));
        }
        return subflowRef;
    }
}

