/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.events.OnEvents;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnEventsActionModeDeserializer
extends StdDeserializer<OnEvents.ActionMode> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(OnEventsActionModeDeserializer.class);
    private WorkflowPropertySource context;

    public OnEventsActionModeDeserializer() {
        this(OnEvents.ActionMode.class);
    }

    public OnEventsActionModeDeserializer(WorkflowPropertySource context) {
        this(OnEvents.ActionMode.class);
        this.context = context;
    }

    public OnEventsActionModeDeserializer(Class<?> vc) {
        super(vc);
    }

    public OnEvents.ActionMode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String value = jp.getText();
        if (this.context != null) {
            try {
                String result = this.context.getPropertySource().getProperty(value);
                if (result != null) {
                    return OnEvents.ActionMode.fromValue(result);
                }
                return OnEvents.ActionMode.fromValue(jp.getText());
            }
            catch (Exception e) {
                logger.info("Exception trying to evaluate property: {}", (Object)e.getMessage());
                return OnEvents.ActionMode.fromValue(jp.getText());
            }
        }
        return OnEvents.ActionMode.fromValue(jp.getText());
    }
}

