/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.functions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"refName", "arguments", "selectionSet", "invoke"})
public class FunctionRef
implements Serializable {
    @JsonProperty(value="refName")
    @JsonPropertyDescription(value="Name of the referenced function")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String refName;
    @JsonProperty(value="arguments")
    @JsonPropertyDescription(value="Function arguments")
    @Valid
    private JsonNode arguments;
    @JsonProperty(value="selectionSet")
    @JsonPropertyDescription(value="Only used if function type is 'graphql'. A string containing a valid GraphQL selection set")
    private String selectionSet;
    @JsonProperty(value="invoke")
    @JsonPropertyDescription(value="Specifies if the function should be invoked sync or async. Default is sync.")
    private Invoke invoke = Invoke.fromValue("sync");
    private static final long serialVersionUID = 5346618996984359931L;

    public FunctionRef() {
    }

    public FunctionRef(String refName) {
        this.refName = refName;
    }

    @JsonProperty(value="refName")
    public String getRefName() {
        return this.refName;
    }

    @JsonProperty(value="refName")
    public void setRefName(String refName) {
        this.refName = refName;
    }

    public FunctionRef withRefName(String refName) {
        this.refName = refName;
        return this;
    }

    @JsonProperty(value="arguments")
    public JsonNode getArguments() {
        return this.arguments;
    }

    @JsonProperty(value="arguments")
    public void setArguments(JsonNode arguments) {
        this.arguments = arguments;
    }

    public FunctionRef withArguments(JsonNode arguments) {
        this.arguments = arguments;
        return this;
    }

    @JsonProperty(value="selectionSet")
    public String getSelectionSet() {
        return this.selectionSet;
    }

    @JsonProperty(value="selectionSet")
    public void setSelectionSet(String selectionSet) {
        this.selectionSet = selectionSet;
    }

    public FunctionRef withSelectionSet(String selectionSet) {
        this.selectionSet = selectionSet;
        return this;
    }

    @JsonProperty(value="invoke")
    public Invoke getInvoke() {
        return this.invoke;
    }

    @JsonProperty(value="invoke")
    public void setInvoke(Invoke invoke) {
        this.invoke = invoke;
    }

    public FunctionRef withInvoke(Invoke invoke) {
        this.invoke = invoke;
        return this;
    }

    public static enum Invoke {
        SYNC("sync"),
        ASYNC("async");

        private final String value;
        private static final Map<String, Invoke> CONSTANTS;

        private Invoke(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Invoke fromValue(String value) {
            Invoke constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Invoke>();
            for (Invoke c : Invoke.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

