/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.repeat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"expression", "checkBefore", "max", "continueOnError", "stopOnEvents"})
public class Repeat
implements Serializable {
    @JsonProperty(value="expression")
    @JsonPropertyDescription(value="Expression evaluated against SubFlow state data. SubFlow will repeat execution as long as this expression is true or until the max property count is reached")
    @Size(min=1)
    private @Size(min=1) String expression;
    @JsonProperty(value="checkBefore")
    @JsonPropertyDescription(value="If true, the expression is evaluated before each repeat execution, if false the expression is evaluated after each repeat execution")
    private boolean checkBefore = true;
    @JsonProperty(value="max")
    @JsonPropertyDescription(value="Sets the maximum amount of repeat executions")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") int max;
    @JsonProperty(value="continueOnError")
    @JsonPropertyDescription(value="If true, repeats executions in a case unhandled errors propagate from the sub-workflow to this state")
    private boolean continueOnError = false;
    @JsonProperty(value="stopOnEvents")
    @JsonPropertyDescription(value="List referencing defined consumed workflow events. SubFlow will repeat execution until one of the defined events is consumed, or until the max property count is reached")
    @Valid
    private List<String> stopOnEvents = new ArrayList<String>();
    private static final long serialVersionUID = 1851955639467650709L;

    @JsonProperty(value="expression")
    public String getExpression() {
        return this.expression;
    }

    @JsonProperty(value="expression")
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Repeat withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    @JsonProperty(value="checkBefore")
    public boolean isCheckBefore() {
        return this.checkBefore;
    }

    @JsonProperty(value="checkBefore")
    public void setCheckBefore(boolean checkBefore) {
        this.checkBefore = checkBefore;
    }

    public Repeat withCheckBefore(boolean checkBefore) {
        this.checkBefore = checkBefore;
        return this;
    }

    @JsonProperty(value="max")
    public int getMax() {
        return this.max;
    }

    @JsonProperty(value="max")
    public void setMax(int max) {
        this.max = max;
    }

    public Repeat withMax(int max) {
        this.max = max;
        return this;
    }

    @JsonProperty(value="continueOnError")
    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    @JsonProperty(value="continueOnError")
    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public Repeat withContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
        return this;
    }

    @JsonProperty(value="stopOnEvents")
    public List<String> getStopOnEvents() {
        return this.stopOnEvents;
    }

    @JsonProperty(value="stopOnEvents")
    public void setStopOnEvents(List<String> stopOnEvents) {
        this.stopOnEvents = stopOnEvents;
    }

    public Repeat withStopOnEvents(List<String> stopOnEvents) {
        this.stopOnEvents = stopOnEvents;
        return this;
    }
}

