/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.serverlessworkflow.serialization.BeanDeserializerModifierWithValidation;
import io.serverlessworkflow.serialization.URIDeserializer;
import io.serverlessworkflow.serialization.URISerializer;
import java.net.URI;

class ObjectMapperFactory {
    private static final ObjectMapper jsonMapper = ObjectMapperFactory.configure(new ObjectMapper());
    private static final ObjectMapper yamlMapper = ObjectMapperFactory.configure(new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES)));

    public static final ObjectMapper jsonMapper() {
        return jsonMapper;
    }

    public static final ObjectMapper yamlMapper() {
        return yamlMapper;
    }

    private static ObjectMapper configure(ObjectMapper mapper) {
        SimpleModule validationModule = new SimpleModule();
        validationModule.addDeserializer(URI.class, (JsonDeserializer)new URIDeserializer());
        validationModule.addSerializer(URI.class, (JsonSerializer)new URISerializer());
        validationModule.setDeserializerModifier((BeanDeserializerModifier)new BeanDeserializerModifierWithValidation());
        return mapper.configure(SerializationFeature.INDENT_OUTPUT, true).configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false).configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false).registerModule((Module)validationModule);
    }

    private ObjectMapperFactory() {
    }
}

