/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.InputFormat;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import io.serverlessworkflow.api.WorkflowFormat;
import io.serverlessworkflow.api.WorkflowReaderOperations;
import io.serverlessworkflow.api.types.Workflow;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Set;
import java.util.stream.Collectors;

class ValidationReader
implements WorkflowReaderOperations {
    private final JsonSchema schemaObject;

    ValidationReader() {
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/workflow.yaml");){
            this.schemaObject = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7).getSchema(input, InputFormat.YAML, SchemaValidatorsConfig.builder().build());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Workflow read(InputStream input, WorkflowFormat format) throws IOException {
        return this.validate((JsonNode)format.mapper().readValue(input, JsonNode.class), format);
    }

    @Override
    public Workflow read(Reader input, WorkflowFormat format) throws IOException {
        return this.validate((JsonNode)format.mapper().readValue(input, JsonNode.class), format);
    }

    @Override
    public Workflow read(byte[] input, WorkflowFormat format) throws IOException {
        return this.validate((JsonNode)format.mapper().readValue(input, JsonNode.class), format);
    }

    @Override
    public Workflow read(String input, WorkflowFormat format) throws IOException {
        return this.validate((JsonNode)format.mapper().readValue(input, JsonNode.class), format);
    }

    private Workflow validate(JsonNode value, WorkflowFormat format) {
        Set validationErrors = this.schemaObject.validate(value);
        if (!validationErrors.isEmpty()) {
            throw new IllegalArgumentException(validationErrors.stream().map(ValidationMessage::toString).collect(Collectors.joining("\n")));
        }
        return (Workflow)format.mapper().convertValue((Object)value, Workflow.class);
    }
}

