/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.serverlessworkflow.api.ObjectMapperFactory;
import java.nio.file.Path;

public enum WorkflowFormat {
    JSON(ObjectMapperFactory.jsonMapper()),
    YAML(ObjectMapperFactory.yamlMapper());

    private final ObjectMapper mapper;

    public static WorkflowFormat fromPath(Path path) {
        return WorkflowFormat.fromFileName(path.getFileName().toString());
    }

    public static WorkflowFormat fromFileName(String fileName) {
        return fileName.endsWith(".json") ? JSON : YAML;
    }

    private WorkflowFormat(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }
}

