/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api;

import io.serverlessworkflow.api.DirectReader;
import io.serverlessworkflow.api.ValidationReader;
import io.serverlessworkflow.api.WorkflowFormat;
import io.serverlessworkflow.api.WorkflowReaderOperations;
import io.serverlessworkflow.api.types.Workflow;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;

public class WorkflowReader {
    public static Workflow readWorkflow(InputStream input, WorkflowFormat format) throws IOException {
        return WorkflowReader.defaultReader().read(input, format);
    }

    public static Workflow readWorkflow(Reader input, WorkflowFormat format) throws IOException {
        return WorkflowReader.defaultReader().read(input, format);
    }

    public static Workflow readWorkflow(byte[] input, WorkflowFormat format) throws IOException {
        return WorkflowReader.defaultReader().read(input, format);
    }

    public static Workflow readWorkflow(Path path) throws IOException {
        return WorkflowReader.readWorkflow(path, WorkflowFormat.fromPath(path), WorkflowReader.defaultReader());
    }

    public static Workflow readWorkflow(Path path, WorkflowFormat format) throws IOException {
        return WorkflowReader.readWorkflow(path, format, WorkflowReader.defaultReader());
    }

    public static Workflow readWorkflowFromString(String input, WorkflowFormat format) throws IOException {
        return WorkflowReader.defaultReader().read(input, format);
    }

    public static Workflow readWorkflowFromClasspath(String classpath) throws IOException {
        return WorkflowReader.readWorkflowFromClasspath(classpath, WorkflowReader.defaultReader());
    }

    public static Workflow readWorkflowFromClasspath(String classpath, ClassLoader cl, WorkflowFormat format) throws IOException {
        return WorkflowReader.readWorkflowFromClasspath(classpath, WorkflowReader.defaultReader());
    }

    public static Workflow readWorkflow(Path path, WorkflowReaderOperations reader) throws IOException {
        return WorkflowReader.readWorkflow(path, WorkflowFormat.fromPath(path), reader);
    }

    public static Workflow readWorkflow(Path path, WorkflowFormat format, WorkflowReaderOperations reader) throws IOException {
        return reader.read(Files.readAllBytes(path), format);
    }

    public static Workflow readWorkflowFromClasspath(String classpath, WorkflowReaderOperations reader) throws IOException {
        return WorkflowReader.readWorkflowFromClasspath(classpath, Thread.currentThread().getContextClassLoader(), WorkflowFormat.fromFileName(classpath), reader);
    }

    public static Workflow readWorkflowFromClasspath(String classpath, ClassLoader cl, WorkflowFormat format, WorkflowReaderOperations reader) throws IOException {
        try (InputStream in = cl.getResourceAsStream(classpath);){
            if (in == null) {
                throw new FileNotFoundException(classpath);
            }
            Workflow workflow = reader.read(in, format);
            return workflow;
        }
    }

    public static WorkflowReaderOperations noValidation() {
        return NoValidationHolder.instance;
    }

    public static WorkflowReaderOperations validation() {
        return ValidationHolder.instance;
    }

    private static WorkflowReaderOperations defaultReader() {
        return NoValidationHolder.instance;
    }

    private WorkflowReader() {
    }

    private static class NoValidationHolder {
        private static final WorkflowReaderOperations instance = new DirectReader();

        private NoValidationHolder() {
        }
    }

    private static class ValidationHolder {
        private static final WorkflowReaderOperations instance = new ValidationReader();

        private ValidationHolder() {
        }
    }
}

