/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api;

import io.serverlessworkflow.api.WorkflowFormat;
import io.serverlessworkflow.api.types.Workflow;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class WorkflowWriter {
    public static void writeWorkflow(OutputStream output, Workflow workflow, WorkflowFormat format) throws IOException {
        format.mapper().writeValue(output, (Object)workflow);
    }

    public static void writeWorkflow(Writer output, Workflow workflow, WorkflowFormat format) throws IOException {
        format.mapper().writeValue(output, (Object)workflow);
    }

    public static void writeWorkflow(Path output, Workflow workflow) throws IOException {
        WorkflowWriter.writeWorkflow(output, workflow, WorkflowFormat.fromPath(output));
    }

    public static void writeWorkflow(Path output, Workflow workflow, WorkflowFormat format) throws IOException {
        try (OutputStream out = Files.newOutputStream(output, new OpenOption[0]);){
            WorkflowWriter.writeWorkflow(out, workflow, format);
        }
    }

    public static String workflowAsString(Workflow workflow, WorkflowFormat format) throws IOException {
        return format.mapper().writeValueAsString((Object)workflow);
    }

    public static byte[] workflowAsBytes(Workflow workflow, WorkflowFormat format) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            WorkflowWriter.writeWorkflow(out, workflow, format);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    private WorkflowWriter() {
    }
}

