/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.serverlessworkflow.api.types.AsyncApiOutboundMessage;
import io.serverlessworkflow.api.types.AsyncApiServer;
import io.serverlessworkflow.api.types.AsyncApiSubscription;
import io.serverlessworkflow.api.types.ExternalResource;
import io.serverlessworkflow.api.types.ReferenceableAuthenticationPolicy;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"document", "channel", "operation", "server", "protocol", "message", "subscription", "authentication"})
public class AsyncApiArguments
implements Serializable {
    @JsonProperty(value="document")
    @JsonPropertyDescription(value="Represents an external resource.")
    @Valid
    private ExternalResource document;
    @JsonProperty(value="channel")
    @JsonPropertyDescription(value="The name of the channel on which to perform the operation. Used only in case the referenced document uses AsyncAPI v2.6.0.")
    private String channel;
    @JsonProperty(value="operation")
    @JsonPropertyDescription(value="A reference to the AsyncAPI operation to call.")
    private String operation;
    @JsonProperty(value="server")
    @JsonPropertyDescription(value="Configures the target server of an AsyncAPI operation.")
    @Valid
    private AsyncApiServer server;
    @JsonProperty(value="protocol")
    @JsonPropertyDescription(value="The protocol to use to select the target server.")
    private AsyncApiProtocol protocol;
    @JsonProperty(value="message")
    @JsonPropertyDescription(value="An object used to configure the message to publish using the target operation.")
    @Valid
    private AsyncApiOutboundMessage message;
    @JsonProperty(value="subscription")
    @JsonPropertyDescription(value="An object used to configure the subscription to messages consumed using the target operation.")
    @Valid
    private AsyncApiSubscription subscription;
    @JsonProperty(value="authentication")
    @JsonPropertyDescription(value="Represents a referenceable authentication policy.")
    @Valid
    private ReferenceableAuthenticationPolicy authentication;
    private static final long serialVersionUID = 171670318271924812L;

    @JsonProperty(value="document")
    public ExternalResource getDocument() {
        return this.document;
    }

    @JsonProperty(value="document")
    public void setDocument(ExternalResource document) {
        this.document = document;
    }

    public AsyncApiArguments withDocument(ExternalResource document) {
        this.document = document;
        return this;
    }

    @JsonProperty(value="channel")
    public String getChannel() {
        return this.channel;
    }

    @JsonProperty(value="channel")
    public void setChannel(String channel) {
        this.channel = channel;
    }

    public AsyncApiArguments withChannel(String channel) {
        this.channel = channel;
        return this;
    }

    @JsonProperty(value="operation")
    public String getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    public void setOperation(String operation) {
        this.operation = operation;
    }

    public AsyncApiArguments withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    @JsonProperty(value="server")
    public AsyncApiServer getServer() {
        return this.server;
    }

    @JsonProperty(value="server")
    public void setServer(AsyncApiServer server) {
        this.server = server;
    }

    public AsyncApiArguments withServer(AsyncApiServer server) {
        this.server = server;
        return this;
    }

    @JsonProperty(value="protocol")
    public AsyncApiProtocol getProtocol() {
        return this.protocol;
    }

    @JsonProperty(value="protocol")
    public void setProtocol(AsyncApiProtocol protocol) {
        this.protocol = protocol;
    }

    public AsyncApiArguments withProtocol(AsyncApiProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    @JsonProperty(value="message")
    public AsyncApiOutboundMessage getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(AsyncApiOutboundMessage message) {
        this.message = message;
    }

    public AsyncApiArguments withMessage(AsyncApiOutboundMessage message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="subscription")
    public AsyncApiSubscription getSubscription() {
        return this.subscription;
    }

    @JsonProperty(value="subscription")
    public void setSubscription(AsyncApiSubscription subscription) {
        this.subscription = subscription;
    }

    public AsyncApiArguments withSubscription(AsyncApiSubscription subscription) {
        this.subscription = subscription;
        return this;
    }

    @JsonProperty(value="authentication")
    public ReferenceableAuthenticationPolicy getAuthentication() {
        return this.authentication;
    }

    @JsonProperty(value="authentication")
    public void setAuthentication(ReferenceableAuthenticationPolicy authentication) {
        this.authentication = authentication;
    }

    public AsyncApiArguments withAuthentication(ReferenceableAuthenticationPolicy authentication) {
        this.authentication = authentication;
        return this;
    }

    public static enum AsyncApiProtocol {
        AMQP("amqp"),
        AMQP_1("amqp1"),
        ANYPOINTMQ("anypointmq"),
        GOOGLEPUBSUB("googlepubsub"),
        HTTP("http"),
        IBMMQ("ibmmq"),
        JMS("jms"),
        KAFKA("kafka"),
        MERCURE("mercure"),
        MQTT("mqtt"),
        MQTT_5("mqtt5"),
        NATS("nats"),
        PULSAR("pulsar"),
        REDIS("redis"),
        SNS("sns"),
        SOLACE("solace"),
        SQS("sqs"),
        STOMP("stomp"),
        WS("ws");

        private final String value;
        private static final Map<String, AsyncApiProtocol> CONSTANTS;

        private AsyncApiProtocol(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AsyncApiProtocol fromValue(String value) {
            AsyncApiProtocol constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AsyncApiProtocol>();
            for (AsyncApiProtocol c : AsyncApiProtocol.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

