/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.types.ContainerEnvironment;
import io.serverlessworkflow.api.types.ContainerLifetime;
import io.serverlessworkflow.api.types.ContainerPorts;
import io.serverlessworkflow.api.types.ContainerVolumes;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"image", "name", "command", "ports", "volumes", "environment", "lifetime"})
public class Container
implements Serializable {
    @JsonProperty(value="image")
    @JsonPropertyDescription(value="The name of the container image to run.")
    @NotNull
    private String image;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="A runtime expression, if any, used to give specific name to the container.")
    private String name;
    @JsonProperty(value="command")
    @JsonPropertyDescription(value="The command, if any, to execute on the container.")
    private String command;
    @JsonProperty(value="ports")
    @JsonPropertyDescription(value="The container's port mappings, if any.")
    @Valid
    private ContainerPorts ports;
    @JsonProperty(value="volumes")
    @JsonPropertyDescription(value="The container's volume mappings, if any.")
    @Valid
    private ContainerVolumes volumes;
    @JsonProperty(value="environment")
    @JsonPropertyDescription(value="A key/value mapping of the environment variables, if any, to use when running the configured process.")
    @Valid
    private ContainerEnvironment environment;
    @JsonProperty(value="lifetime")
    @JsonPropertyDescription(value="The configuration of a container's lifetime")
    @Valid
    private ContainerLifetime lifetime;
    private static final long serialVersionUID = -7563185011345649524L;

    public Container() {
    }

    public Container(String image) {
        this.image = image;
    }

    @JsonProperty(value="image")
    public String getImage() {
        return this.image;
    }

    @JsonProperty(value="image")
    public void setImage(String image) {
        this.image = image;
    }

    public Container withImage(String image) {
        this.image = image;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Container withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="command")
    public String getCommand() {
        return this.command;
    }

    @JsonProperty(value="command")
    public void setCommand(String command) {
        this.command = command;
    }

    public Container withCommand(String command) {
        this.command = command;
        return this;
    }

    @JsonProperty(value="ports")
    public ContainerPorts getPorts() {
        return this.ports;
    }

    @JsonProperty(value="ports")
    public void setPorts(ContainerPorts ports) {
        this.ports = ports;
    }

    public Container withPorts(ContainerPorts ports) {
        this.ports = ports;
        return this;
    }

    @JsonProperty(value="volumes")
    public ContainerVolumes getVolumes() {
        return this.volumes;
    }

    @JsonProperty(value="volumes")
    public void setVolumes(ContainerVolumes volumes) {
        this.volumes = volumes;
    }

    public Container withVolumes(ContainerVolumes volumes) {
        this.volumes = volumes;
        return this;
    }

    @JsonProperty(value="environment")
    public ContainerEnvironment getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="environment")
    public void setEnvironment(ContainerEnvironment environment) {
        this.environment = environment;
    }

    public Container withEnvironment(ContainerEnvironment environment) {
        this.environment = environment;
        return this;
    }

    @JsonProperty(value="lifetime")
    public ContainerLifetime getLifetime() {
        return this.lifetime;
    }

    @JsonProperty(value="lifetime")
    public void setLifetime(ContainerLifetime lifetime) {
        this.lifetime = lifetime;
    }

    public Container withLifetime(ContainerLifetime lifetime) {
        this.lifetime = lifetime;
        return this;
    }
}

