/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.serverlessworkflow.api.types.TimeoutAfter;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"cleanup", "after"})
public class ContainerLifetime
implements Serializable {
    @JsonProperty(value="cleanup")
    @JsonPropertyDescription(value="The container cleanup policy to use")
    @NotNull
    private ContainerCleanupPolicy cleanup = ContainerCleanupPolicy.fromValue("never");
    @JsonProperty(value="after")
    private TimeoutAfter after;
    private static final long serialVersionUID = 1447338477138586940L;

    public ContainerLifetime() {
    }

    public ContainerLifetime(ContainerCleanupPolicy cleanup) {
        this.cleanup = cleanup;
    }

    @JsonProperty(value="cleanup")
    public ContainerCleanupPolicy getCleanup() {
        return this.cleanup;
    }

    @JsonProperty(value="cleanup")
    public void setCleanup(ContainerCleanupPolicy cleanup) {
        this.cleanup = cleanup;
    }

    public ContainerLifetime withCleanup(ContainerCleanupPolicy cleanup) {
        this.cleanup = cleanup;
        return this;
    }

    @JsonProperty(value="after")
    public TimeoutAfter getAfter() {
        return this.after;
    }

    @JsonProperty(value="after")
    public void setAfter(TimeoutAfter after) {
        this.after = after;
    }

    public ContainerLifetime withAfter(TimeoutAfter after) {
        this.after = after;
        return this;
    }

    public static enum ContainerCleanupPolicy {
        ALWAYS("always"),
        NEVER("never"),
        EVENTUALLY("eventually");

        private final String value;
        private static final Map<String, ContainerCleanupPolicy> CONSTANTS;

        private ContainerCleanupPolicy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ContainerCleanupPolicy fromValue(String value) {
            ContainerCleanupPolicy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ContainerCleanupPolicy>();
            for (ContainerCleanupPolicy c : ContainerCleanupPolicy.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

