/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.types.WorkflowMetadata;
import io.serverlessworkflow.api.types.WorkflowTags;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"dsl", "namespace", "name", "version", "title", "summary", "tags", "metadata"})
public class Document
implements Serializable {
    @JsonProperty(value="dsl")
    @JsonPropertyDescription(value="The version of the DSL used by the workflow.")
    @Pattern(regexp="^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$")
    @NotNull
    private @Pattern(regexp="^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$") @NotNull String dsl;
    @JsonProperty(value="namespace")
    @JsonPropertyDescription(value="The workflow's namespace.")
    @Pattern(regexp="^[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?$")
    @NotNull
    private @Pattern(regexp="^[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?$") @NotNull String namespace;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The workflow's name.")
    @Pattern(regexp="^[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?$")
    @NotNull
    private @Pattern(regexp="^[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?$") @NotNull String name;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="The workflow's semantic version.")
    @Pattern(regexp="^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$")
    @NotNull
    private @Pattern(regexp="^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$") @NotNull String version;
    @JsonProperty(value="title")
    @JsonPropertyDescription(value="The workflow's title.")
    private String title;
    @JsonProperty(value="summary")
    @JsonPropertyDescription(value="The workflow's Markdown summary.")
    private String summary;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="A key/value mapping of the workflow's tags, if any.")
    @Valid
    private WorkflowTags tags;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Holds additional information about the workflow.")
    @Valid
    private WorkflowMetadata metadata;
    private static final long serialVersionUID = -8838629639123887548L;

    public Document() {
    }

    public Document(String dsl, String namespace, String name, String version) {
        this.dsl = dsl;
        this.namespace = namespace;
        this.name = name;
        this.version = version;
    }

    @JsonProperty(value="dsl")
    public String getDsl() {
        return this.dsl;
    }

    @JsonProperty(value="dsl")
    public void setDsl(String dsl) {
        this.dsl = dsl;
    }

    public Document withDsl(String dsl) {
        this.dsl = dsl;
        return this;
    }

    @JsonProperty(value="namespace")
    public String getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Document withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Document withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    public Document withVersion(String version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public Document withTitle(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty(value="summary")
    public String getSummary() {
        return this.summary;
    }

    @JsonProperty(value="summary")
    public void setSummary(String summary) {
        this.summary = summary;
    }

    public Document withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    @JsonProperty(value="tags")
    public WorkflowTags getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(WorkflowTags tags) {
        this.tags = tags;
    }

    public Document withTags(WorkflowTags tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="metadata")
    public WorkflowMetadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(WorkflowMetadata metadata) {
        this.metadata = metadata;
    }

    public Document withMetadata(WorkflowMetadata metadata) {
        this.metadata = metadata;
        return this;
    }
}

