/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.serverlessworkflow.api.OneOfValueProvider;
import io.serverlessworkflow.api.types.EndpointConfiguration;
import io.serverlessworkflow.api.types.EndpointDeserializer;
import io.serverlessworkflow.api.types.EndpointSerializer;
import io.serverlessworkflow.api.types.UriTemplate;
import io.serverlessworkflow.serialization.OneOfSetter;
import jakarta.validation.ConstraintViolationException;
import java.util.regex.Pattern;

@JsonSerialize(using=EndpointSerializer.class)
@JsonDeserialize(using=EndpointDeserializer.class)
public class Endpoint
implements OneOfValueProvider<Object> {
    private Object value;
    private UriTemplate uriTemplate;
    private EndpointConfiguration endpointConfiguration;
    private String runtimeExpression;
    private static final Pattern runtimeExpression_Pattern = Pattern.compile("^\\s*\\$\\{.+\\}\\s*$");

    @Override
    public Object get() {
        return this.value;
    }

    public UriTemplate getUriTemplate() {
        return this.uriTemplate;
    }

    public Endpoint withUriTemplate(UriTemplate value) {
        this.uriTemplate = value;
        return this;
    }

    @OneOfSetter(value=UriTemplate.class)
    public void setUriTemplate(UriTemplate uriTemplate) {
        this.value = uriTemplate;
        this.uriTemplate = uriTemplate;
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public Endpoint withEndpointConfiguration(EndpointConfiguration value) {
        this.endpointConfiguration = value;
        return this;
    }

    @OneOfSetter(value=EndpointConfiguration.class)
    public void setEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.value = endpointConfiguration;
        this.endpointConfiguration = endpointConfiguration;
    }

    public String getRuntimeExpression() {
        return this.runtimeExpression;
    }

    public Endpoint withRuntimeExpression(String value) {
        this.runtimeExpression = value;
        return this;
    }

    @OneOfSetter(value=String.class)
    public void setRuntimeExpression(String runtimeExpression) {
        this.value = runtimeExpression;
        if (!runtimeExpression_Pattern.matcher(runtimeExpression).matches()) {
            throw new ConstraintViolationException(String.format("%s does not match any pattern", runtimeExpression), null);
        }
        this.runtimeExpression = runtimeExpression;
    }
}

