/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.types.EndpointUri;
import io.serverlessworkflow.api.types.ReferenceableAuthenticationPolicy;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"uri", "authentication"})
public class EndpointConfiguration
implements Serializable {
    @JsonProperty(value="uri")
    @JsonPropertyDescription(value="The endpoint's URI.")
    @NotNull
    private EndpointUri uri;
    @JsonProperty(value="authentication")
    @JsonPropertyDescription(value="Represents a referenceable authentication policy.")
    @Valid
    private ReferenceableAuthenticationPolicy authentication;
    private static final long serialVersionUID = -7546601616894114358L;

    public EndpointConfiguration() {
    }

    public EndpointConfiguration(EndpointUri uri) {
        this.uri = uri;
    }

    @JsonProperty(value="uri")
    public EndpointUri getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    public void setUri(EndpointUri uri) {
        this.uri = uri;
    }

    public EndpointConfiguration withUri(EndpointUri uri) {
        this.uri = uri;
        return this;
    }

    @JsonProperty(value="authentication")
    public ReferenceableAuthenticationPolicy getAuthentication() {
        return this.authentication;
    }

    @JsonProperty(value="authentication")
    public void setAuthentication(ReferenceableAuthenticationPolicy authentication) {
        this.authentication = authentication;
    }

    public EndpointConfiguration withAuthentication(ReferenceableAuthenticationPolicy authentication) {
        this.authentication = authentication;
        return this;
    }
}

