/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.serverlessworkflow.api.OneOfValueProvider;
import io.serverlessworkflow.api.types.EndpointUriDeserializer;
import io.serverlessworkflow.api.types.EndpointUriSerializer;
import io.serverlessworkflow.api.types.UriTemplate;
import io.serverlessworkflow.serialization.OneOfSetter;
import jakarta.validation.ConstraintViolationException;
import java.util.regex.Pattern;

@JsonSerialize(using=EndpointUriSerializer.class)
@JsonDeserialize(using=EndpointUriDeserializer.class)
public class EndpointUri
implements OneOfValueProvider<Object> {
    private Object value;
    private UriTemplate literalEndpointURI;
    private String expressionEndpointURI;
    private static final Pattern expressionEndpointURI_Pattern = Pattern.compile("^\\s*\\$\\{.+\\}\\s*$");

    @Override
    public Object get() {
        return this.value;
    }

    public UriTemplate getLiteralEndpointURI() {
        return this.literalEndpointURI;
    }

    public EndpointUri withLiteralEndpointURI(UriTemplate value) {
        this.literalEndpointURI = value;
        return this;
    }

    @OneOfSetter(value=UriTemplate.class)
    public void setLiteralEndpointURI(UriTemplate literalEndpointURI) {
        this.value = literalEndpointURI;
        this.literalEndpointURI = literalEndpointURI;
    }

    public String getExpressionEndpointURI() {
        return this.expressionEndpointURI;
    }

    public EndpointUri withExpressionEndpointURI(String value) {
        this.expressionEndpointURI = value;
        return this;
    }

    @OneOfSetter(value=String.class)
    public void setExpressionEndpointURI(String expressionEndpointURI) {
        this.value = expressionEndpointURI;
        if (!expressionEndpointURI_Pattern.matcher(expressionEndpointURI).matches()) {
            throw new ConstraintViolationException(String.format("%s does not match any pattern", expressionEndpointURI), null);
        }
        this.expressionEndpointURI = expressionEndpointURI;
    }
}

