/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.serverlessworkflow.api.OneOfValueProvider;
import io.serverlessworkflow.api.types.ErrorInstanceDeserializer;
import io.serverlessworkflow.api.types.ErrorInstanceSerializer;
import io.serverlessworkflow.serialization.OneOfSetter;
import jakarta.validation.ConstraintViolationException;
import java.util.regex.Pattern;

@JsonSerialize(using=ErrorInstanceSerializer.class)
@JsonDeserialize(using=ErrorInstanceDeserializer.class)
public class ErrorInstance
implements OneOfValueProvider<Object> {
    private Object value;
    private String expressionErrorInstance;
    private static final Pattern expressionErrorInstance_Pattern = Pattern.compile("^\\s*\\$\\{.+\\}\\s*$");
    private String literalErrorInstance;
    private static final Pattern literalErrorInstance_Pattern = Pattern.compile(".*");

    @Override
    public Object get() {
        return this.value;
    }

    public String getExpressionErrorInstance() {
        return this.expressionErrorInstance;
    }

    public ErrorInstance withExpressionErrorInstance(String value) {
        this.expressionErrorInstance = value;
        return this;
    }

    @OneOfSetter(value=String.class)
    public void setExpressionErrorInstance(String expressionErrorInstance) {
        this.value = expressionErrorInstance;
        if (expressionErrorInstance_Pattern.matcher(expressionErrorInstance).matches()) {
            this.expressionErrorInstance = expressionErrorInstance;
        } else if (literalErrorInstance_Pattern.matcher(expressionErrorInstance).matches()) {
            this.literalErrorInstance = expressionErrorInstance;
        } else {
            throw new ConstraintViolationException(String.format("%s does not match any pattern", expressionErrorInstance), null);
        }
    }

    public String getLiteralErrorInstance() {
        return this.literalErrorInstance;
    }
}

