/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.serverlessworkflow.api.OneOfValueProvider;
import io.serverlessworkflow.api.types.ErrorTypeDeserializer;
import io.serverlessworkflow.api.types.ErrorTypeSerializer;
import io.serverlessworkflow.api.types.UriTemplate;
import io.serverlessworkflow.serialization.OneOfSetter;
import jakarta.validation.ConstraintViolationException;
import java.util.regex.Pattern;

@JsonSerialize(using=ErrorTypeSerializer.class)
@JsonDeserialize(using=ErrorTypeDeserializer.class)
public class ErrorType
implements OneOfValueProvider<Object> {
    private Object value;
    private UriTemplate literalErrorType;
    private String expressionErrorType;
    private static final Pattern expressionErrorType_Pattern = Pattern.compile("^\\s*\\$\\{.+\\}\\s*$");

    @Override
    public Object get() {
        return this.value;
    }

    public UriTemplate getLiteralErrorType() {
        return this.literalErrorType;
    }

    public ErrorType withLiteralErrorType(UriTemplate value) {
        this.literalErrorType = value;
        return this;
    }

    @OneOfSetter(value=UriTemplate.class)
    public void setLiteralErrorType(UriTemplate literalErrorType) {
        this.value = literalErrorType;
        this.literalErrorType = literalErrorType;
    }

    public String getExpressionErrorType() {
        return this.expressionErrorType;
    }

    public ErrorType withExpressionErrorType(String value) {
        this.expressionErrorType = value;
        return this;
    }

    @OneOfSetter(value=String.class)
    public void setExpressionErrorType(String expressionErrorType) {
        this.value = expressionErrorType;
        if (!expressionErrorType_Pattern.matcher(expressionErrorType).matches()) {
            throw new ConstraintViolationException(String.format("%s does not match any pattern", expressionErrorType), null);
        }
        this.expressionErrorType = expressionErrorType;
    }
}

