/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.serverlessworkflow.api.OneOfValueProvider;
import io.serverlessworkflow.api.types.EventDataDeserializer;
import io.serverlessworkflow.api.types.EventDataSerializer;
import io.serverlessworkflow.serialization.OneOfSetter;
import jakarta.validation.ConstraintViolationException;
import java.util.regex.Pattern;

@JsonSerialize(using=EventDataSerializer.class)
@JsonDeserialize(using=EventDataDeserializer.class)
public class EventData
implements OneOfValueProvider<Object> {
    private Object value;
    private Object object;
    private String runtimeExpression;
    private static final Pattern runtimeExpression_Pattern = Pattern.compile("^\\s*\\$\\{.+\\}\\s*$");

    @Override
    public Object get() {
        return this.value;
    }

    public Object getObject() {
        return this.object;
    }

    public EventData withObject(Object value) {
        this.object = value;
        return this;
    }

    @OneOfSetter(value=Object.class)
    public void setObject(Object object) {
        this.value = object;
        this.object = object;
    }

    public String getRuntimeExpression() {
        return this.runtimeExpression;
    }

    public EventData withRuntimeExpression(String value) {
        this.runtimeExpression = value;
        return this;
    }

    @OneOfSetter(value=String.class)
    public void setRuntimeExpression(String runtimeExpression) {
        this.value = runtimeExpression;
        if (!runtimeExpression_Pattern.matcher(runtimeExpression).matches()) {
            throw new ConstraintViolationException(String.format("%s does not match any pattern", runtimeExpression), null);
        }
        this.runtimeExpression = runtimeExpression;
    }
}

