/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.serverlessworkflow.api.OneOfValueProvider;
import io.serverlessworkflow.api.types.EventDataschemaDeserializer;
import io.serverlessworkflow.api.types.EventDataschemaSerializer;
import io.serverlessworkflow.api.types.UriTemplate;
import io.serverlessworkflow.serialization.OneOfSetter;
import jakarta.validation.ConstraintViolationException;
import java.util.regex.Pattern;

@JsonSerialize(using=EventDataschemaSerializer.class)
@JsonDeserialize(using=EventDataschemaDeserializer.class)
public class EventDataschema
implements OneOfValueProvider<Object> {
    private Object value;
    private UriTemplate literalDataSchema;
    private String expressionDataSchema;
    private static final Pattern expressionDataSchema_Pattern = Pattern.compile("^\\s*\\$\\{.+\\}\\s*$");

    @Override
    public Object get() {
        return this.value;
    }

    public UriTemplate getLiteralDataSchema() {
        return this.literalDataSchema;
    }

    public EventDataschema withLiteralDataSchema(UriTemplate value) {
        this.literalDataSchema = value;
        return this;
    }

    @OneOfSetter(value=UriTemplate.class)
    public void setLiteralDataSchema(UriTemplate literalDataSchema) {
        this.value = literalDataSchema;
        this.literalDataSchema = literalDataSchema;
    }

    public String getExpressionDataSchema() {
        return this.expressionDataSchema;
    }

    public EventDataschema withExpressionDataSchema(String value) {
        this.expressionDataSchema = value;
        return this;
    }

    @OneOfSetter(value=String.class)
    public void setExpressionDataSchema(String expressionDataSchema) {
        this.value = expressionDataSchema;
        if (!expressionDataSchema_Pattern.matcher(expressionDataSchema).matches()) {
            throw new ConstraintViolationException(String.format("%s does not match any pattern", expressionDataSchema), null);
        }
        this.expressionDataSchema = expressionDataSchema;
    }
}

