/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.types.EventData;
import io.serverlessworkflow.api.types.EventDataschema;
import io.serverlessworkflow.api.types.EventSource;
import io.serverlessworkflow.api.types.EventTime;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "source", "type", "time", "subject", "datacontenttype", "dataschema", "data"})
public class EventProperties
implements Serializable {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="The event's unique identifier.")
    private String id;
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="Identifies the context in which an event happened.")
    private EventSource source;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="This attribute contains a value describing the type of event related to the originating occurrence.")
    private String type;
    @JsonProperty(value="time")
    @JsonPropertyDescription(value="When the event occured.")
    private EventTime time;
    @JsonProperty(value="subject")
    @JsonPropertyDescription(value="The subject of the event.")
    private String subject;
    @JsonProperty(value="datacontenttype")
    @JsonPropertyDescription(value="Content type of data value. This attribute enables data to carry any type of content, whereby format and encoding might differ from that of the chosen event format.")
    private String datacontenttype;
    @JsonProperty(value="dataschema")
    @JsonPropertyDescription(value="The schema describing the event format.")
    private EventDataschema dataschema;
    @JsonProperty(value="data")
    @JsonPropertyDescription(value="The event's payload data")
    private EventData data;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = 6574842982457449904L;

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public EventProperties withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="source")
    public EventSource getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(EventSource source) {
        this.source = source;
    }

    public EventProperties withSource(EventSource source) {
        this.source = source;
        return this;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    public EventProperties withType(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="time")
    public EventTime getTime() {
        return this.time;
    }

    @JsonProperty(value="time")
    public void setTime(EventTime time) {
        this.time = time;
    }

    public EventProperties withTime(EventTime time) {
        this.time = time;
        return this;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public EventProperties withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    @JsonProperty(value="datacontenttype")
    public String getDatacontenttype() {
        return this.datacontenttype;
    }

    @JsonProperty(value="datacontenttype")
    public void setDatacontenttype(String datacontenttype) {
        this.datacontenttype = datacontenttype;
    }

    public EventProperties withDatacontenttype(String datacontenttype) {
        this.datacontenttype = datacontenttype;
        return this;
    }

    @JsonProperty(value="dataschema")
    public EventDataschema getDataschema() {
        return this.dataschema;
    }

    @JsonProperty(value="dataschema")
    public void setDataschema(EventDataschema dataschema) {
        this.dataschema = dataschema;
    }

    public EventProperties withDataschema(EventDataschema dataschema) {
        this.dataschema = dataschema;
        return this;
    }

    @JsonProperty(value="data")
    public EventData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(EventData data) {
        this.data = data;
    }

    public EventProperties withData(EventData data) {
        this.data = data;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public EventProperties withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }
}

