/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.serverlessworkflow.api.OneOfValueProvider;
import io.serverlessworkflow.api.types.EventTimeDeserializer;
import io.serverlessworkflow.api.types.EventTimeSerializer;
import io.serverlessworkflow.serialization.OneOfSetter;
import jakarta.validation.ConstraintViolationException;
import java.util.Date;
import java.util.regex.Pattern;

@JsonSerialize(using=EventTimeSerializer.class)
@JsonDeserialize(using=EventTimeDeserializer.class)
public class EventTime
implements OneOfValueProvider<Object> {
    private Object value;
    private Date literalTime;
    private String runtimeExpression;
    private static final Pattern runtimeExpression_Pattern = Pattern.compile("^\\s*\\$\\{.+\\}\\s*$");

    @Override
    public Object get() {
        return this.value;
    }

    public Date getLiteralTime() {
        return this.literalTime;
    }

    public EventTime withLiteralTime(Date value) {
        this.literalTime = value;
        return this;
    }

    @OneOfSetter(value=Date.class)
    public void setLiteralTime(Date literalTime) {
        this.value = literalTime;
        this.literalTime = literalTime;
    }

    public String getRuntimeExpression() {
        return this.runtimeExpression;
    }

    public EventTime withRuntimeExpression(String value) {
        this.runtimeExpression = value;
        return this;
    }

    @OneOfSetter(value=String.class)
    public void setRuntimeExpression(String runtimeExpression) {
        this.value = runtimeExpression;
        if (!runtimeExpression_Pattern.matcher(runtimeExpression).matches()) {
            throw new ConstraintViolationException(String.format("%s does not match any pattern", runtimeExpression), null);
        }
        this.runtimeExpression = runtimeExpression;
    }
}

