/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.serverlessworkflow.api.types.TaskItem;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"extend", "when", "before", "after"})
public class Extension
implements Serializable {
    @JsonProperty(value="extend")
    @JsonPropertyDescription(value="The type of task to extend.")
    @NotNull
    private ExtensionTarget extend;
    @JsonProperty(value="when")
    @JsonPropertyDescription(value="A runtime expression, if any, used to determine whether or not the extension should apply in the specified context.")
    private String when;
    @JsonProperty(value="before")
    @JsonPropertyDescription(value="List of named tasks to perform.")
    @Valid
    private List<TaskItem> before = new ArrayList<TaskItem>();
    @JsonProperty(value="after")
    @JsonPropertyDescription(value="List of named tasks to perform.")
    @Valid
    private List<TaskItem> after = new ArrayList<TaskItem>();
    private static final long serialVersionUID = 4976401151480321437L;

    public Extension() {
    }

    public Extension(ExtensionTarget extend) {
        this.extend = extend;
    }

    @JsonProperty(value="extend")
    public ExtensionTarget getExtend() {
        return this.extend;
    }

    @JsonProperty(value="extend")
    public void setExtend(ExtensionTarget extend) {
        this.extend = extend;
    }

    public Extension withExtend(ExtensionTarget extend) {
        this.extend = extend;
        return this;
    }

    @JsonProperty(value="when")
    public String getWhen() {
        return this.when;
    }

    @JsonProperty(value="when")
    public void setWhen(String when) {
        this.when = when;
    }

    public Extension withWhen(String when) {
        this.when = when;
        return this;
    }

    @JsonProperty(value="before")
    public List<TaskItem> getBefore() {
        return this.before;
    }

    @JsonProperty(value="before")
    public void setBefore(List<TaskItem> before) {
        this.before = before;
    }

    public Extension withBefore(List<TaskItem> before) {
        this.before = before;
        return this;
    }

    @JsonProperty(value="after")
    public List<TaskItem> getAfter() {
        return this.after;
    }

    @JsonProperty(value="after")
    public void setAfter(List<TaskItem> after) {
        this.after = after;
    }

    public Extension withAfter(List<TaskItem> after) {
        this.after = after;
        return this;
    }

    public static enum ExtensionTarget {
        CALL("call"),
        COMPOSITE("composite"),
        EMIT("emit"),
        FOR("for"),
        LISTEN("listen"),
        RAISE("raise"),
        RUN("run"),
        SET("set"),
        SWITCH("switch"),
        TRY("try"),
        WAIT("wait"),
        ALL("all");

        private final String value;
        private static final Map<String, ExtensionTarget> CONSTANTS;

        private ExtensionTarget(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ExtensionTarget fromValue(String value) {
            ExtensionTarget constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ExtensionTarget>();
            for (ExtensionTarget c : ExtensionTarget.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

